/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregatorFilterType;
import software.amazon.awssdk.services.config.model.ServicePrincipalValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatorFilterServicePrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatorFilterServicePrincipal> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AggregatorFilterServicePrincipal.getter(AggregatorFilterServicePrincipal::typeAsString)).setter(AggregatorFilterServicePrincipal.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Value").getter(AggregatorFilterServicePrincipal.getter(AggregatorFilterServicePrincipal::value)).setter(AggregatorFilterServicePrincipal.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregatorFilterServicePrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<String> value;

    private AggregatorFilterServicePrincipal(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    public final AggregatorFilterType type() {
        return AggregatorFilterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasValue() {
        return this.value != null && !(this.value instanceof SdkAutoConstructList);
    }

    public final List<String> value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValue() ? this.value() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatorFilterServicePrincipal)) {
            return false;
        }
        AggregatorFilterServicePrincipal other = (AggregatorFilterServicePrincipal)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasValue() == other.hasValue() && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"AggregatorFilterServicePrincipal").add("Type", (Object)this.typeAsString()).add("Value", this.hasValue() ? this.value() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregatorFilterServicePrincipal, T> g) {
        return obj -> g.apply((AggregatorFilterServicePrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<String> value = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatorFilterServicePrincipal model) {
            this.type(model.type);
            this.value(model.value);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AggregatorFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getValue() {
            if (this.value instanceof SdkAutoConstructList) {
                return null;
            }
            return this.value;
        }

        public final void setValue(Collection<String> value) {
            this.value = ServicePrincipalValueListCopier.copy(value);
        }

        @Override
        public final Builder value(Collection<String> value) {
            this.value = ServicePrincipalValueListCopier.copy(value);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder value(String ... value) {
            this.value(Arrays.asList(value));
            return this;
        }

        public AggregatorFilterServicePrincipal build() {
            return new AggregatorFilterServicePrincipal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatorFilterServicePrincipal> {
        public Builder type(String var1);

        public Builder type(AggregatorFilterType var1);

        public Builder value(Collection<String> var1);

        public Builder value(String ... var1);
    }
}

