/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigRule;
import software.amazon.awssdk.services.config.model.ConfigRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigRulesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigRulesResponse> {
    private static final SdkField<List<ConfigRule>> CONFIG_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigRules").getter(DescribeConfigRulesResponse.getter(DescribeConfigRulesResponse::configRules)).setter(DescribeConfigRulesResponse.setter(Builder::configRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConfigRulesResponse.getter(DescribeConfigRulesResponse::nextToken)).setter(DescribeConfigRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConfigRulesResponse.memberNameToFieldInitializer();
    private final List<ConfigRule> configRules;
    private final String nextToken;

    private DescribeConfigRulesResponse(BuilderImpl builder) {
        super(builder);
        this.configRules = builder.configRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigRules() {
        return this.configRules != null && !(this.configRules instanceof SdkAutoConstructList);
    }

    public final List<ConfigRule> configRules() {
        return this.configRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigRules() ? this.configRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRulesResponse)) {
            return false;
        }
        DescribeConfigRulesResponse other = (DescribeConfigRulesResponse)((Object)obj);
        return this.hasConfigRules() == other.hasConfigRules() && Objects.equals(this.configRules(), other.configRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigRulesResponse").add("ConfigRules", this.hasConfigRules() ? this.configRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRules": {
                return Optional.ofNullable(clazz.cast(this.configRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigRules", CONFIG_RULES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigRulesResponse, T> g) {
        return obj -> g.apply((DescribeConfigRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigRule> configRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRulesResponse model) {
            super(model);
            this.configRules(model.configRules);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigRule.Builder> getConfigRules() {
            List<ConfigRule.Builder> result = ConfigRulesCopier.copyToBuilder(this.configRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigRules(Collection<ConfigRule.BuilderImpl> configRules) {
            this.configRules = ConfigRulesCopier.copyFromBuilder(configRules);
        }

        @Override
        public final Builder configRules(Collection<ConfigRule> configRules) {
            this.configRules = ConfigRulesCopier.copy(configRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRules(ConfigRule ... configRules) {
            this.configRules(Arrays.asList(configRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRules(Consumer<ConfigRule.Builder> ... configRules) {
            this.configRules(Stream.of(configRules).map(c -> (ConfigRule)((ConfigRule.Builder)ConfigRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConfigRulesResponse build() {
            return new DescribeConfigRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigRulesResponse> {
        public Builder configRules(Collection<ConfigRule> var1);

        public Builder configRules(ConfigRule ... var1);

        public Builder configRules(Consumer<ConfigRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

