/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerTypesCopier;
import software.amazon.awssdk.services.config.model.ResourceTypesScopeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationCustomRuleMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationCustomRuleMetadata> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::description)).setter(OrganizationCustomRuleMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaFunctionArn").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::lambdaFunctionArn)).setter(OrganizationCustomRuleMetadata.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn").build()}).build();
    private static final SdkField<List<String>> ORGANIZATION_CONFIG_RULE_TRIGGER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConfigRuleTriggerTypes").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::organizationConfigRuleTriggerTypesAsStrings)).setter(OrganizationCustomRuleMetadata.setter(Builder::organizationConfigRuleTriggerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleTriggerTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputParameters").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::inputParameters)).setter(OrganizationCustomRuleMetadata.setter(Builder::inputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParameters").build()}).build();
    private static final SdkField<String> MAXIMUM_EXECUTION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumExecutionFrequency").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::maximumExecutionFrequencyAsString)).setter(OrganizationCustomRuleMetadata.setter(Builder::maximumExecutionFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionFrequency").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypesScope").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::resourceTypesScope)).setter(OrganizationCustomRuleMetadata.setter(Builder::resourceTypesScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypesScope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ID_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdScope").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::resourceIdScope)).setter(OrganizationCustomRuleMetadata.setter(Builder::resourceIdScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdScope").build()}).build();
    private static final SdkField<String> TAG_KEY_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKeyScope").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::tagKeyScope)).setter(OrganizationCustomRuleMetadata.setter(Builder::tagKeyScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyScope").build()}).build();
    private static final SdkField<String> TAG_VALUE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagValueScope").getter(OrganizationCustomRuleMetadata.getter(OrganizationCustomRuleMetadata::tagValueScope)).setter(OrganizationCustomRuleMetadata.setter(Builder::tagValueScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValueScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, LAMBDA_FUNCTION_ARN_FIELD, ORGANIZATION_CONFIG_RULE_TRIGGER_TYPES_FIELD, INPUT_PARAMETERS_FIELD, MAXIMUM_EXECUTION_FREQUENCY_FIELD, RESOURCE_TYPES_SCOPE_FIELD, RESOURCE_ID_SCOPE_FIELD, TAG_KEY_SCOPE_FIELD, TAG_VALUE_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationCustomRuleMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String lambdaFunctionArn;
    private final List<String> organizationConfigRuleTriggerTypes;
    private final String inputParameters;
    private final String maximumExecutionFrequency;
    private final List<String> resourceTypesScope;
    private final String resourceIdScope;
    private final String tagKeyScope;
    private final String tagValueScope;

    private OrganizationCustomRuleMetadata(BuilderImpl builder) {
        this.description = builder.description;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.organizationConfigRuleTriggerTypes = builder.organizationConfigRuleTriggerTypes;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.resourceTypesScope = builder.resourceTypesScope;
        this.resourceIdScope = builder.resourceIdScope;
        this.tagKeyScope = builder.tagKeyScope;
        this.tagValueScope = builder.tagValueScope;
    }

    public final String description() {
        return this.description;
    }

    public final String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public final List<OrganizationConfigRuleTriggerType> organizationConfigRuleTriggerTypes() {
        return OrganizationConfigRuleTriggerTypesCopier.copyStringToEnum(this.organizationConfigRuleTriggerTypes);
    }

    public final boolean hasOrganizationConfigRuleTriggerTypes() {
        return this.organizationConfigRuleTriggerTypes != null && !(this.organizationConfigRuleTriggerTypes instanceof SdkAutoConstructList);
    }

    public final List<String> organizationConfigRuleTriggerTypesAsStrings() {
        return this.organizationConfigRuleTriggerTypes;
    }

    public final String inputParameters() {
        return this.inputParameters;
    }

    public final MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(this.maximumExecutionFrequency);
    }

    public final String maximumExecutionFrequencyAsString() {
        return this.maximumExecutionFrequency;
    }

    public final boolean hasResourceTypesScope() {
        return this.resourceTypesScope != null && !(this.resourceTypesScope instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesScope() {
        return this.resourceTypesScope;
    }

    public final String resourceIdScope() {
        return this.resourceIdScope;
    }

    public final String tagKeyScope() {
        return this.tagKeyScope;
    }

    public final String tagValueScope() {
        return this.tagValueScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConfigRuleTriggerTypes() ? this.organizationConfigRuleTriggerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypesScope() ? this.resourceTypesScope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeyScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValueScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationCustomRuleMetadata)) {
            return false;
        }
        OrganizationCustomRuleMetadata other = (OrganizationCustomRuleMetadata)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn()) && this.hasOrganizationConfigRuleTriggerTypes() == other.hasOrganizationConfigRuleTriggerTypes() && Objects.equals(this.organizationConfigRuleTriggerTypesAsStrings(), other.organizationConfigRuleTriggerTypesAsStrings()) && Objects.equals(this.inputParameters(), other.inputParameters()) && Objects.equals(this.maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString()) && this.hasResourceTypesScope() == other.hasResourceTypesScope() && Objects.equals(this.resourceTypesScope(), other.resourceTypesScope()) && Objects.equals(this.resourceIdScope(), other.resourceIdScope()) && Objects.equals(this.tagKeyScope(), other.tagKeyScope()) && Objects.equals(this.tagValueScope(), other.tagValueScope());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationCustomRuleMetadata").add("Description", (Object)this.description()).add("LambdaFunctionArn", (Object)this.lambdaFunctionArn()).add("OrganizationConfigRuleTriggerTypes", this.hasOrganizationConfigRuleTriggerTypes() ? this.organizationConfigRuleTriggerTypesAsStrings() : null).add("InputParameters", (Object)this.inputParameters()).add("MaximumExecutionFrequency", (Object)this.maximumExecutionFrequencyAsString()).add("ResourceTypesScope", this.hasResourceTypesScope() ? this.resourceTypesScope() : null).add("ResourceIdScope", (Object)this.resourceIdScope()).add("TagKeyScope", (Object)this.tagKeyScope()).add("TagValueScope", (Object)this.tagValueScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
            case "OrganizationConfigRuleTriggerTypes": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleTriggerTypesAsStrings()));
            }
            case "InputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "MaximumExecutionFrequency": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionFrequencyAsString()));
            }
            case "ResourceTypesScope": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesScope()));
            }
            case "ResourceIdScope": {
                return Optional.ofNullable(clazz.cast(this.resourceIdScope()));
            }
            case "TagKeyScope": {
                return Optional.ofNullable(clazz.cast(this.tagKeyScope()));
            }
            case "TagValueScope": {
                return Optional.ofNullable(clazz.cast(this.tagValueScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LambdaFunctionArn", LAMBDA_FUNCTION_ARN_FIELD);
        map.put("OrganizationConfigRuleTriggerTypes", ORGANIZATION_CONFIG_RULE_TRIGGER_TYPES_FIELD);
        map.put("InputParameters", INPUT_PARAMETERS_FIELD);
        map.put("MaximumExecutionFrequency", MAXIMUM_EXECUTION_FREQUENCY_FIELD);
        map.put("ResourceTypesScope", RESOURCE_TYPES_SCOPE_FIELD);
        map.put("ResourceIdScope", RESOURCE_ID_SCOPE_FIELD);
        map.put("TagKeyScope", TAG_KEY_SCOPE_FIELD);
        map.put("TagValueScope", TAG_VALUE_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationCustomRuleMetadata, T> g) {
        return obj -> g.apply((OrganizationCustomRuleMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String lambdaFunctionArn;
        private List<String> organizationConfigRuleTriggerTypes = DefaultSdkAutoConstructList.getInstance();
        private String inputParameters;
        private String maximumExecutionFrequency;
        private List<String> resourceTypesScope = DefaultSdkAutoConstructList.getInstance();
        private String resourceIdScope;
        private String tagKeyScope;
        private String tagValueScope;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationCustomRuleMetadata model) {
            this.description(model.description);
            this.lambdaFunctionArn(model.lambdaFunctionArn);
            this.organizationConfigRuleTriggerTypesWithStrings(model.organizationConfigRuleTriggerTypes);
            this.inputParameters(model.inputParameters);
            this.maximumExecutionFrequency(model.maximumExecutionFrequency);
            this.resourceTypesScope(model.resourceTypesScope);
            this.resourceIdScope(model.resourceIdScope);
            this.tagKeyScope(model.tagKeyScope);
            this.tagValueScope(model.tagValueScope);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final Collection<String> getOrganizationConfigRuleTriggerTypes() {
            if (this.organizationConfigRuleTriggerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationConfigRuleTriggerTypes;
        }

        public final void setOrganizationConfigRuleTriggerTypes(Collection<String> organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes = OrganizationConfigRuleTriggerTypesCopier.copy(organizationConfigRuleTriggerTypes);
        }

        @Override
        public final Builder organizationConfigRuleTriggerTypesWithStrings(Collection<String> organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes = OrganizationConfigRuleTriggerTypesCopier.copy(organizationConfigRuleTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleTriggerTypesWithStrings(String ... organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypesWithStrings(Arrays.asList(organizationConfigRuleTriggerTypes));
            return this;
        }

        @Override
        public final Builder organizationConfigRuleTriggerTypes(Collection<OrganizationConfigRuleTriggerType> organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes = OrganizationConfigRuleTriggerTypesCopier.copyEnumToString(organizationConfigRuleTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleTriggerTypes(OrganizationConfigRuleTriggerType ... organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes(Arrays.asList(organizationConfigRuleTriggerTypes));
            return this;
        }

        public final String getInputParameters() {
            return this.inputParameters;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency == null ? null : maximumExecutionFrequency.toString());
            return this;
        }

        public final Collection<String> getResourceTypesScope() {
            if (this.resourceTypesScope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypesScope;
        }

        public final void setResourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
        }

        @Override
        public final Builder resourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesScope(String ... resourceTypesScope) {
            this.resourceTypesScope(Arrays.asList(resourceTypesScope));
            return this;
        }

        public final String getResourceIdScope() {
            return this.resourceIdScope;
        }

        public final void setResourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
        }

        @Override
        public final Builder resourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
            return this;
        }

        public final String getTagKeyScope() {
            return this.tagKeyScope;
        }

        public final void setTagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
        }

        @Override
        public final Builder tagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
            return this;
        }

        public final String getTagValueScope() {
            return this.tagValueScope;
        }

        public final void setTagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
        }

        @Override
        public final Builder tagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
            return this;
        }

        public OrganizationCustomRuleMetadata build() {
            return new OrganizationCustomRuleMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationCustomRuleMetadata> {
        public Builder description(String var1);

        public Builder lambdaFunctionArn(String var1);

        public Builder organizationConfigRuleTriggerTypesWithStrings(Collection<String> var1);

        public Builder organizationConfigRuleTriggerTypesWithStrings(String ... var1);

        public Builder organizationConfigRuleTriggerTypes(Collection<OrganizationConfigRuleTriggerType> var1);

        public Builder organizationConfigRuleTriggerTypes(OrganizationConfigRuleTriggerType ... var1);

        public Builder inputParameters(String var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);

        public Builder resourceTypesScope(Collection<String> var1);

        public Builder resourceTypesScope(String ... var1);

        public Builder resourceIdScope(String var1);

        public Builder tagKeyScope(String var1);

        public Builder tagValueScope(String var1);
    }
}

