/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ComplianceByResource;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;

public class DescribeComplianceByResourcePublisher
implements SdkPublisher<DescribeComplianceByResourceResponse> {
    private final ConfigAsyncClient client;
    private final DescribeComplianceByResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeComplianceByResourcePublisher(ConfigAsyncClient client, DescribeComplianceByResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeComplianceByResourcePublisher(ConfigAsyncClient client, DescribeComplianceByResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeComplianceByResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeComplianceByResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComplianceByResource> complianceByResources() {
        Function<DescribeComplianceByResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.complianceByResources() != null) {
                return response.complianceByResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeComplianceByResourceResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeComplianceByResourceResponseFetcher
    implements AsyncPageFetcher<DescribeComplianceByResourceResponse> {
        private DescribeComplianceByResourceResponseFetcher() {
        }

        public boolean hasNextPage(DescribeComplianceByResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeComplianceByResourceResponse> nextPage(DescribeComplianceByResourceResponse previousPage) {
            if (previousPage == null) {
                return DescribeComplianceByResourcePublisher.this.client.describeComplianceByResource(DescribeComplianceByResourcePublisher.this.firstRequest);
            }
            return DescribeComplianceByResourcePublisher.this.client.describeComplianceByResource((DescribeComplianceByResourceRequest)((Object)DescribeComplianceByResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

