/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability;

public class DescribeScheduledInstanceAvailabilityIterable
implements SdkIterable<DescribeScheduledInstanceAvailabilityResponse> {
    private final Ec2Client client;
    private final DescribeScheduledInstanceAvailabilityRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScheduledInstanceAvailabilityIterable(Ec2Client client, DescribeScheduledInstanceAvailabilityRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeScheduledInstanceAvailabilityResponseFetcher();
    }

    public Iterator<DescribeScheduledInstanceAvailabilityResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet() {
        Function<DescribeScheduledInstanceAvailabilityResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledInstanceAvailabilitySet() != null) {
                return response.scheduledInstanceAvailabilitySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeScheduledInstanceAvailabilityResponseFetcher
    implements SyncPageFetcher<DescribeScheduledInstanceAvailabilityResponse> {
        private DescribeScheduledInstanceAvailabilityResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledInstanceAvailabilityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeScheduledInstanceAvailabilityResponse nextPage(DescribeScheduledInstanceAvailabilityResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledInstanceAvailabilityIterable.this.client.describeScheduledInstanceAvailability(DescribeScheduledInstanceAvailabilityIterable.this.firstRequest);
            }
            return DescribeScheduledInstanceAvailabilityIterable.this.client.describeScheduledInstanceAvailability((DescribeScheduledInstanceAvailabilityRequest)((Object)DescribeScheduledInstanceAvailabilityIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

