/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportsResponse;
import software.amazon.awssdk.services.ec2.model.ImageUsageReport;

public class DescribeImageUsageReportsPublisher
implements SdkPublisher<DescribeImageUsageReportsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeImageUsageReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImageUsageReportsPublisher(Ec2AsyncClient client, DescribeImageUsageReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImageUsageReportsPublisher(Ec2AsyncClient client, DescribeImageUsageReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImageUsageReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImageUsageReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageUsageReport> imageUsageReports() {
        Function<DescribeImageUsageReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageUsageReports() != null) {
                return response.imageUsageReports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeImageUsageReportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeImageUsageReportsResponseFetcher
    implements AsyncPageFetcher<DescribeImageUsageReportsResponse> {
        private DescribeImageUsageReportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageUsageReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImageUsageReportsResponse> nextPage(DescribeImageUsageReportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageUsageReportsPublisher.this.client.describeImageUsageReports(DescribeImageUsageReportsPublisher.this.firstRequest);
            }
            return DescribeImageUsageReportsPublisher.this.client.describeImageUsageReports((DescribeImageUsageReportsRequest)((Object)DescribeImageUsageReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

