/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Comparison;
import software.amazon.awssdk.services.ec2.model.ConditionValueListCopier;
import software.amazon.awssdk.services.ec2.model.FilterByDimension;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionCondition> {
    private static final SdkField<String> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dimension").getter(DimensionCondition.getter(DimensionCondition::dimensionAsString)).setter(DimensionCondition.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").unmarshallLocationName("Dimension").build()}).build();
    private static final SdkField<String> COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comparison").getter(DimensionCondition.getter(DimensionCondition::comparisonAsString)).setter(DimensionCondition.setter(Builder::comparison)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").unmarshallLocationName("Comparison").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(DimensionCondition.getter(DimensionCondition::values)).setter(DimensionCondition.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").unmarshallLocationName("Value").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD, COMPARISON_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DimensionCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dimension;
    private final String comparison;
    private final List<String> values;

    private DimensionCondition(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.comparison = builder.comparison;
        this.values = builder.values;
    }

    public final FilterByDimension dimension() {
        return FilterByDimension.fromValue(this.dimension);
    }

    public final String dimensionAsString() {
        return this.dimension;
    }

    public final Comparison comparison() {
        return Comparison.fromValue(this.comparison);
    }

    public final String comparisonAsString() {
        return this.comparison;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionCondition)) {
            return false;
        }
        DimensionCondition other = (DimensionCondition)obj;
        return Objects.equals(this.dimensionAsString(), other.dimensionAsString()) && Objects.equals(this.comparisonAsString(), other.comparisonAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"DimensionCondition").add("Dimension", (Object)this.dimensionAsString()).add("Comparison", (Object)this.comparisonAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimensionAsString()));
            }
            case "Comparison": {
                return Optional.ofNullable(clazz.cast(this.comparisonAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimension", DIMENSION_FIELD);
        map.put("Comparison", COMPARISON_FIELD);
        map.put("Value", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionCondition, T> g) {
        return obj -> g.apply((DimensionCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimension;
        private String comparison;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionCondition model) {
            this.dimension(model.dimension);
            this.comparison(model.comparison);
            this.values(model.values);
        }

        public final String getDimension() {
            return this.dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        @Override
        public final Builder dimension(FilterByDimension dimension) {
            this.dimension(dimension == null ? null : dimension.toString());
            return this;
        }

        public final String getComparison() {
            return this.comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        @Override
        public final Builder comparison(Comparison comparison) {
            this.comparison(comparison == null ? null : comparison.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ConditionValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ConditionValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public DimensionCondition build() {
            return new DimensionCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionCondition> {
        public Builder dimension(String var1);

        public Builder dimension(FilterByDimension var1);

        public Builder comparison(String var1);

        public Builder comparison(Comparison var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

