/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Reservation;

public class DescribeInstancesPublisher
implements SdkPublisher<DescribeInstancesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstancesPublisher(Ec2AsyncClient client, DescribeInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstancesPublisher(Ec2AsyncClient client, DescribeInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Reservation> reservations() {
        Function<DescribeInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservations() != null) {
                return response.reservations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeInstancesResponse> {
        private DescribeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstancesResponse> nextPage(DescribeInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancesPublisher.this.client.describeInstances(DescribeInstancesPublisher.this.firstRequest);
            }
            return DescribeInstancesPublisher.this.client.describeInstances((DescribeInstancesRequest)((Object)DescribeInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

