/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDataExportStatus;
import software.amazon.awssdk.services.ec2.model.OutputFormat;
import software.amazon.awssdk.services.ec2.model.Schedule;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityManagerDataExportResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityManagerDataExportResponse> {
    private static final SdkField<String> CAPACITY_MANAGER_DATA_EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityManagerDataExportId").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::capacityManagerDataExportId)).setter(CapacityManagerDataExportResponse.setter(Builder::capacityManagerDataExportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerDataExportId").unmarshallLocationName("capacityManagerDataExportId").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::s3BucketName)).setter(CapacityManagerDataExportResponse.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").unmarshallLocationName("s3BucketName").build()}).build();
    private static final SdkField<String> S3_BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketPrefix").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::s3BucketPrefix)).setter(CapacityManagerDataExportResponse.setter(Builder::s3BucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketPrefix").unmarshallLocationName("s3BucketPrefix").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::scheduleAsString)).setter(CapacityManagerDataExportResponse.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").unmarshallLocationName("schedule").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::outputFormatAsString)).setter(CapacityManagerDataExportResponse.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").unmarshallLocationName("outputFormat").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::createTime)).setter(CapacityManagerDataExportResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<String> LATEST_DELIVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestDeliveryStatus").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::latestDeliveryStatusAsString)).setter(CapacityManagerDataExportResponse.setter(Builder::latestDeliveryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryStatus").unmarshallLocationName("latestDeliveryStatus").build()}).build();
    private static final SdkField<String> LATEST_DELIVERY_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestDeliveryStatusMessage").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::latestDeliveryStatusMessage)).setter(CapacityManagerDataExportResponse.setter(Builder::latestDeliveryStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryStatusMessage").unmarshallLocationName("latestDeliveryStatusMessage").build()}).build();
    private static final SdkField<String> LATEST_DELIVERY_S3_LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestDeliveryS3LocationUri").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::latestDeliveryS3LocationUri)).setter(CapacityManagerDataExportResponse.setter(Builder::latestDeliveryS3LocationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryS3LocationUri").unmarshallLocationName("latestDeliveryS3LocationUri").build()}).build();
    private static final SdkField<Instant> LATEST_DELIVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestDeliveryTime").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::latestDeliveryTime)).setter(CapacityManagerDataExportResponse.setter(Builder::latestDeliveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryTime").unmarshallLocationName("latestDeliveryTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CapacityManagerDataExportResponse.getter(CapacityManagerDataExportResponse::tags)).setter(CapacityManagerDataExportResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_MANAGER_DATA_EXPORT_ID_FIELD, S3_BUCKET_NAME_FIELD, S3_BUCKET_PREFIX_FIELD, SCHEDULE_FIELD, OUTPUT_FORMAT_FIELD, CREATE_TIME_FIELD, LATEST_DELIVERY_STATUS_FIELD, LATEST_DELIVERY_STATUS_MESSAGE_FIELD, LATEST_DELIVERY_S3_LOCATION_URI_FIELD, LATEST_DELIVERY_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityManagerDataExportResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityManagerDataExportId;
    private final String s3BucketName;
    private final String s3BucketPrefix;
    private final String schedule;
    private final String outputFormat;
    private final Instant createTime;
    private final String latestDeliveryStatus;
    private final String latestDeliveryStatusMessage;
    private final String latestDeliveryS3LocationUri;
    private final Instant latestDeliveryTime;
    private final List<Tag> tags;

    private CapacityManagerDataExportResponse(BuilderImpl builder) {
        this.capacityManagerDataExportId = builder.capacityManagerDataExportId;
        this.s3BucketName = builder.s3BucketName;
        this.s3BucketPrefix = builder.s3BucketPrefix;
        this.schedule = builder.schedule;
        this.outputFormat = builder.outputFormat;
        this.createTime = builder.createTime;
        this.latestDeliveryStatus = builder.latestDeliveryStatus;
        this.latestDeliveryStatusMessage = builder.latestDeliveryStatusMessage;
        this.latestDeliveryS3LocationUri = builder.latestDeliveryS3LocationUri;
        this.latestDeliveryTime = builder.latestDeliveryTime;
        this.tags = builder.tags;
    }

    public final String capacityManagerDataExportId() {
        return this.capacityManagerDataExportId;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3BucketPrefix() {
        return this.s3BucketPrefix;
    }

    public final Schedule schedule() {
        return Schedule.fromValue(this.schedule);
    }

    public final String scheduleAsString() {
        return this.schedule;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final CapacityManagerDataExportStatus latestDeliveryStatus() {
        return CapacityManagerDataExportStatus.fromValue(this.latestDeliveryStatus);
    }

    public final String latestDeliveryStatusAsString() {
        return this.latestDeliveryStatus;
    }

    public final String latestDeliveryStatusMessage() {
        return this.latestDeliveryStatusMessage;
    }

    public final String latestDeliveryS3LocationUri() {
        return this.latestDeliveryS3LocationUri;
    }

    public final Instant latestDeliveryTime() {
        return this.latestDeliveryTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityManagerDataExportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDeliveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDeliveryStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDeliveryS3LocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityManagerDataExportResponse)) {
            return false;
        }
        CapacityManagerDataExportResponse other = (CapacityManagerDataExportResponse)obj;
        return Objects.equals(this.capacityManagerDataExportId(), other.capacityManagerDataExportId()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3BucketPrefix(), other.s3BucketPrefix()) && Objects.equals(this.scheduleAsString(), other.scheduleAsString()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.latestDeliveryStatusAsString(), other.latestDeliveryStatusAsString()) && Objects.equals(this.latestDeliveryStatusMessage(), other.latestDeliveryStatusMessage()) && Objects.equals(this.latestDeliveryS3LocationUri(), other.latestDeliveryS3LocationUri()) && Objects.equals(this.latestDeliveryTime(), other.latestDeliveryTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityManagerDataExportResponse").add("CapacityManagerDataExportId", (Object)this.capacityManagerDataExportId()).add("S3BucketName", (Object)this.s3BucketName()).add("S3BucketPrefix", (Object)this.s3BucketPrefix()).add("Schedule", (Object)this.scheduleAsString()).add("OutputFormat", (Object)this.outputFormatAsString()).add("CreateTime", (Object)this.createTime()).add("LatestDeliveryStatus", (Object)this.latestDeliveryStatusAsString()).add("LatestDeliveryStatusMessage", (Object)this.latestDeliveryStatusMessage()).add("LatestDeliveryS3LocationUri", (Object)this.latestDeliveryS3LocationUri()).add("LatestDeliveryTime", (Object)this.latestDeliveryTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityManagerDataExportId": {
                return Optional.ofNullable(clazz.cast(this.capacityManagerDataExportId()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3BucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3BucketPrefix()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.scheduleAsString()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "LatestDeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.latestDeliveryStatusAsString()));
            }
            case "LatestDeliveryStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.latestDeliveryStatusMessage()));
            }
            case "LatestDeliveryS3LocationUri": {
                return Optional.ofNullable(clazz.cast(this.latestDeliveryS3LocationUri()));
            }
            case "LatestDeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.latestDeliveryTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityManagerDataExportId", CAPACITY_MANAGER_DATA_EXPORT_ID_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3BucketPrefix", S3_BUCKET_PREFIX_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("LatestDeliveryStatus", LATEST_DELIVERY_STATUS_FIELD);
        map.put("LatestDeliveryStatusMessage", LATEST_DELIVERY_STATUS_MESSAGE_FIELD);
        map.put("LatestDeliveryS3LocationUri", LATEST_DELIVERY_S3_LOCATION_URI_FIELD);
        map.put("LatestDeliveryTime", LATEST_DELIVERY_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityManagerDataExportResponse, T> g) {
        return obj -> g.apply((CapacityManagerDataExportResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityManagerDataExportId;
        private String s3BucketName;
        private String s3BucketPrefix;
        private String schedule;
        private String outputFormat;
        private Instant createTime;
        private String latestDeliveryStatus;
        private String latestDeliveryStatusMessage;
        private String latestDeliveryS3LocationUri;
        private Instant latestDeliveryTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityManagerDataExportResponse model) {
            this.capacityManagerDataExportId(model.capacityManagerDataExportId);
            this.s3BucketName(model.s3BucketName);
            this.s3BucketPrefix(model.s3BucketPrefix);
            this.schedule(model.schedule);
            this.outputFormat(model.outputFormat);
            this.createTime(model.createTime);
            this.latestDeliveryStatus(model.latestDeliveryStatus);
            this.latestDeliveryStatusMessage(model.latestDeliveryStatusMessage);
            this.latestDeliveryS3LocationUri(model.latestDeliveryS3LocationUri);
            this.latestDeliveryTime(model.latestDeliveryTime);
            this.tags(model.tags);
        }

        public final String getCapacityManagerDataExportId() {
            return this.capacityManagerDataExportId;
        }

        public final void setCapacityManagerDataExportId(String capacityManagerDataExportId) {
            this.capacityManagerDataExportId = capacityManagerDataExportId;
        }

        @Override
        public final Builder capacityManagerDataExportId(String capacityManagerDataExportId) {
            this.capacityManagerDataExportId = capacityManagerDataExportId;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3BucketPrefix() {
            return this.s3BucketPrefix;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getLatestDeliveryStatus() {
            return this.latestDeliveryStatus;
        }

        public final void setLatestDeliveryStatus(String latestDeliveryStatus) {
            this.latestDeliveryStatus = latestDeliveryStatus;
        }

        @Override
        public final Builder latestDeliveryStatus(String latestDeliveryStatus) {
            this.latestDeliveryStatus = latestDeliveryStatus;
            return this;
        }

        @Override
        public final Builder latestDeliveryStatus(CapacityManagerDataExportStatus latestDeliveryStatus) {
            this.latestDeliveryStatus(latestDeliveryStatus == null ? null : latestDeliveryStatus.toString());
            return this;
        }

        public final String getLatestDeliveryStatusMessage() {
            return this.latestDeliveryStatusMessage;
        }

        public final void setLatestDeliveryStatusMessage(String latestDeliveryStatusMessage) {
            this.latestDeliveryStatusMessage = latestDeliveryStatusMessage;
        }

        @Override
        public final Builder latestDeliveryStatusMessage(String latestDeliveryStatusMessage) {
            this.latestDeliveryStatusMessage = latestDeliveryStatusMessage;
            return this;
        }

        public final String getLatestDeliveryS3LocationUri() {
            return this.latestDeliveryS3LocationUri;
        }

        public final void setLatestDeliveryS3LocationUri(String latestDeliveryS3LocationUri) {
            this.latestDeliveryS3LocationUri = latestDeliveryS3LocationUri;
        }

        @Override
        public final Builder latestDeliveryS3LocationUri(String latestDeliveryS3LocationUri) {
            this.latestDeliveryS3LocationUri = latestDeliveryS3LocationUri;
            return this;
        }

        public final Instant getLatestDeliveryTime() {
            return this.latestDeliveryTime;
        }

        public final void setLatestDeliveryTime(Instant latestDeliveryTime) {
            this.latestDeliveryTime = latestDeliveryTime;
        }

        @Override
        public final Builder latestDeliveryTime(Instant latestDeliveryTime) {
            this.latestDeliveryTime = latestDeliveryTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapacityManagerDataExportResponse build() {
            return new CapacityManagerDataExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityManagerDataExportResponse> {
        public Builder capacityManagerDataExportId(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3BucketPrefix(String var1);

        public Builder schedule(String var1);

        public Builder schedule(Schedule var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder createTime(Instant var1);

        public Builder latestDeliveryStatus(String var1);

        public Builder latestDeliveryStatus(CapacityManagerDataExportStatus var1);

        public Builder latestDeliveryStatusMessage(String var1);

        public Builder latestDeliveryS3LocationUri(String var1);

        public Builder latestDeliveryTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

