/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.NetworkNodeSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationTopology
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationTopology> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(CapacityReservationTopology.getter(CapacityReservationTopology::capacityReservationId)).setter(CapacityReservationTopology.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("capacityReservationId").build()}).build();
    private static final SdkField<String> CAPACITY_BLOCK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityBlockId").getter(CapacityReservationTopology.getter(CapacityReservationTopology::capacityBlockId)).setter(CapacityReservationTopology.setter(Builder::capacityBlockId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockId").unmarshallLocationName("capacityBlockId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CapacityReservationTopology.getter(CapacityReservationTopology::state)).setter(CapacityReservationTopology.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CapacityReservationTopology.getter(CapacityReservationTopology::instanceType)).setter(CapacityReservationTopology.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(CapacityReservationTopology.getter(CapacityReservationTopology::groupName)).setter(CapacityReservationTopology.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<List<String>> NETWORK_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkNodes").getter(CapacityReservationTopology.getter(CapacityReservationTopology::networkNodes)).setter(CapacityReservationTopology.setter(Builder::networkNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkNodeSet").unmarshallLocationName("networkNodeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CapacityReservationTopology.getter(CapacityReservationTopology::availabilityZoneId)).setter(CapacityReservationTopology.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CapacityReservationTopology.getter(CapacityReservationTopology::availabilityZone)).setter(CapacityReservationTopology.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD, CAPACITY_BLOCK_ID_FIELD, STATE_FIELD, INSTANCE_TYPE_FIELD, GROUP_NAME_FIELD, NETWORK_NODES_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABILITY_ZONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityReservationTopology.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityReservationId;
    private final String capacityBlockId;
    private final String state;
    private final String instanceType;
    private final String groupName;
    private final List<String> networkNodes;
    private final String availabilityZoneId;
    private final String availabilityZone;

    private CapacityReservationTopology(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.capacityBlockId = builder.capacityBlockId;
        this.state = builder.state;
        this.instanceType = builder.instanceType;
        this.groupName = builder.groupName;
        this.networkNodes = builder.networkNodes;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availabilityZone = builder.availabilityZone;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final String capacityBlockId() {
        return this.capacityBlockId;
    }

    public final String state() {
        return this.state;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final boolean hasNetworkNodes() {
        return this.networkNodes != null && !(this.networkNodes instanceof SdkAutoConstructList);
    }

    public final List<String> networkNodes() {
        return this.networkNodes;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkNodes() ? this.networkNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationTopology)) {
            return false;
        }
        CapacityReservationTopology other = (CapacityReservationTopology)obj;
        return Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.capacityBlockId(), other.capacityBlockId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.groupName(), other.groupName()) && this.hasNetworkNodes() == other.hasNetworkNodes() && Objects.equals(this.networkNodes(), other.networkNodes()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservationTopology").add("CapacityReservationId", (Object)this.capacityReservationId()).add("CapacityBlockId", (Object)this.capacityBlockId()).add("State", (Object)this.state()).add("InstanceType", (Object)this.instanceType()).add("GroupName", (Object)this.groupName()).add("NetworkNodes", this.hasNetworkNodes() ? this.networkNodes() : null).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "CapacityBlockId": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "NetworkNodes": {
                return Optional.ofNullable(clazz.cast(this.networkNodes()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("CapacityBlockId", CAPACITY_BLOCK_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("NetworkNodeSet", NETWORK_NODES_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationTopology, T> g) {
        return obj -> g.apply((CapacityReservationTopology)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationId;
        private String capacityBlockId;
        private String state;
        private String instanceType;
        private String groupName;
        private List<String> networkNodes = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZoneId;
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationTopology model) {
            this.capacityReservationId(model.capacityReservationId);
            this.capacityBlockId(model.capacityBlockId);
            this.state(model.state);
            this.instanceType(model.instanceType);
            this.groupName(model.groupName);
            this.networkNodes(model.networkNodes);
            this.availabilityZoneId(model.availabilityZoneId);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getCapacityBlockId() {
            return this.capacityBlockId;
        }

        public final void setCapacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
        }

        @Override
        public final Builder capacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Collection<String> getNetworkNodes() {
            if (this.networkNodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkNodes;
        }

        public final void setNetworkNodes(Collection<String> networkNodes) {
            this.networkNodes = NetworkNodeSetCopier.copy(networkNodes);
        }

        @Override
        public final Builder networkNodes(Collection<String> networkNodes) {
            this.networkNodes = NetworkNodeSetCopier.copy(networkNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkNodes(String ... networkNodes) {
            this.networkNodes(Arrays.asList(networkNodes));
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public CapacityReservationTopology build() {
            return new CapacityReservationTopology(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationTopology> {
        public Builder capacityReservationId(String var1);

        public Builder capacityBlockId(String var1);

        public Builder state(String var1);

        public Builder instanceType(String var1);

        public Builder groupName(String var1);

        public Builder networkNodes(Collection<String> var1);

        public Builder networkNodes(String ... var1);

        public Builder availabilityZoneId(String var1);

        public Builder availabilityZone(String var1);
    }
}

