/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ImageUsageReport;
import software.amazon.awssdk.services.ec2.model.ImageUsageReportListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageUsageReportsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeImageUsageReportsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeImageUsageReportsResponse.getter(DescribeImageUsageReportsResponse::nextToken)).setter(DescribeImageUsageReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<ImageUsageReport>> IMAGE_USAGE_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageUsageReports").getter(DescribeImageUsageReportsResponse.getter(DescribeImageUsageReportsResponse::imageUsageReports)).setter(DescribeImageUsageReportsResponse.setter(Builder::imageUsageReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUsageReportSet").unmarshallLocationName("imageUsageReportSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageUsageReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IMAGE_USAGE_REPORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImageUsageReportsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ImageUsageReport> imageUsageReports;

    private DescribeImageUsageReportsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.imageUsageReports = builder.imageUsageReports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasImageUsageReports() {
        return this.imageUsageReports != null && !(this.imageUsageReports instanceof SdkAutoConstructList);
    }

    public final List<ImageUsageReport> imageUsageReports() {
        return this.imageUsageReports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageUsageReports() ? this.imageUsageReports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageUsageReportsResponse)) {
            return false;
        }
        DescribeImageUsageReportsResponse other = (DescribeImageUsageReportsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasImageUsageReports() == other.hasImageUsageReports() && Objects.equals(this.imageUsageReports(), other.imageUsageReports());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageUsageReportsResponse").add("NextToken", (Object)this.nextToken()).add("ImageUsageReports", this.hasImageUsageReports() ? this.imageUsageReports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ImageUsageReports": {
                return Optional.ofNullable(clazz.cast(this.imageUsageReports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ImageUsageReportSet", IMAGE_USAGE_REPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageUsageReportsResponse, T> g) {
        return obj -> g.apply((DescribeImageUsageReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ImageUsageReport> imageUsageReports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageUsageReportsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.imageUsageReports(model.imageUsageReports);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImageUsageReport.Builder> getImageUsageReports() {
            List<ImageUsageReport.Builder> result = ImageUsageReportListCopier.copyToBuilder(this.imageUsageReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageUsageReports(Collection<ImageUsageReport.BuilderImpl> imageUsageReports) {
            this.imageUsageReports = ImageUsageReportListCopier.copyFromBuilder(imageUsageReports);
        }

        @Override
        public final Builder imageUsageReports(Collection<ImageUsageReport> imageUsageReports) {
            this.imageUsageReports = ImageUsageReportListCopier.copy(imageUsageReports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageUsageReports(ImageUsageReport ... imageUsageReports) {
            this.imageUsageReports(Arrays.asList(imageUsageReports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageUsageReports(Consumer<ImageUsageReport.Builder> ... imageUsageReports) {
            this.imageUsageReports(Stream.of(imageUsageReports).map(c -> (ImageUsageReport)((ImageUsageReport.Builder)ImageUsageReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageUsageReportsResponse build() {
            return new DescribeImageUsageReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageUsageReportsResponse> {
        public Builder nextToken(String var1);

        public Builder imageUsageReports(Collection<ImageUsageReport> var1);

        public Builder imageUsageReports(ImageUsageReport ... var1);

        public Builder imageUsageReports(Consumer<ImageUsageReport.Builder> ... var1);
    }
}

