/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamPrefixListResolverVersionEntriesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetIpamPrefixListResolverVersionEntriesRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetIpamPrefixListResolverVersionEntriesRequest.getter(GetIpamPrefixListResolverVersionEntriesRequest::dryRun)).setter(GetIpamPrefixListResolverVersionEntriesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverId").getter(GetIpamPrefixListResolverVersionEntriesRequest.getter(GetIpamPrefixListResolverVersionEntriesRequest::ipamPrefixListResolverId)).setter(GetIpamPrefixListResolverVersionEntriesRequest.setter(Builder::ipamPrefixListResolverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverId").unmarshallLocationName("IpamPrefixListResolverId").build()}).build();
    private static final SdkField<Long> IPAM_PREFIX_LIST_RESOLVER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IpamPrefixListResolverVersion").getter(GetIpamPrefixListResolverVersionEntriesRequest.getter(GetIpamPrefixListResolverVersionEntriesRequest::ipamPrefixListResolverVersion)).setter(GetIpamPrefixListResolverVersionEntriesRequest.setter(Builder::ipamPrefixListResolverVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverVersion").unmarshallLocationName("IpamPrefixListResolverVersion").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetIpamPrefixListResolverVersionEntriesRequest.getter(GetIpamPrefixListResolverVersionEntriesRequest::maxResults)).setter(GetIpamPrefixListResolverVersionEntriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamPrefixListResolverVersionEntriesRequest.getter(GetIpamPrefixListResolverVersionEntriesRequest::nextToken)).setter(GetIpamPrefixListResolverVersionEntriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_PREFIX_LIST_RESOLVER_ID_FIELD, IPAM_PREFIX_LIST_RESOLVER_VERSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIpamPrefixListResolverVersionEntriesRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamPrefixListResolverId;
    private final Long ipamPrefixListResolverVersion;
    private final Integer maxResults;
    private final String nextToken;

    private GetIpamPrefixListResolverVersionEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPrefixListResolverId = builder.ipamPrefixListResolverId;
        this.ipamPrefixListResolverVersion = builder.ipamPrefixListResolverVersion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPrefixListResolverId() {
        return this.ipamPrefixListResolverId;
    }

    public final Long ipamPrefixListResolverVersion() {
        return this.ipamPrefixListResolverVersion;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamPrefixListResolverVersionEntriesRequest)) {
            return false;
        }
        GetIpamPrefixListResolverVersionEntriesRequest other = (GetIpamPrefixListResolverVersionEntriesRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPrefixListResolverId(), other.ipamPrefixListResolverId()) && Objects.equals(this.ipamPrefixListResolverVersion(), other.ipamPrefixListResolverVersion()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamPrefixListResolverVersionEntriesRequest").add("DryRun", (Object)this.dryRun()).add("IpamPrefixListResolverId", (Object)this.ipamPrefixListResolverId()).add("IpamPrefixListResolverVersion", (Object)this.ipamPrefixListResolverVersion()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPrefixListResolverId": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverId()));
            }
            case "IpamPrefixListResolverVersion": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverVersion()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPrefixListResolverId", IPAM_PREFIX_LIST_RESOLVER_ID_FIELD);
        map.put("IpamPrefixListResolverVersion", IPAM_PREFIX_LIST_RESOLVER_VERSION_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamPrefixListResolverVersionEntriesRequest, T> g) {
        return obj -> g.apply((GetIpamPrefixListResolverVersionEntriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPrefixListResolverId;
        private Long ipamPrefixListResolverVersion;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamPrefixListResolverVersionEntriesRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPrefixListResolverId(model.ipamPrefixListResolverId);
            this.ipamPrefixListResolverVersion(model.ipamPrefixListResolverVersion);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPrefixListResolverId() {
            return this.ipamPrefixListResolverId;
        }

        public final void setIpamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
        }

        @Override
        public final Builder ipamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
            return this;
        }

        public final Long getIpamPrefixListResolverVersion() {
            return this.ipamPrefixListResolverVersion;
        }

        public final void setIpamPrefixListResolverVersion(Long ipamPrefixListResolverVersion) {
            this.ipamPrefixListResolverVersion = ipamPrefixListResolverVersion;
        }

        @Override
        public final Builder ipamPrefixListResolverVersion(Long ipamPrefixListResolverVersion) {
            this.ipamPrefixListResolverVersion = ipamPrefixListResolverVersion;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIpamPrefixListResolverVersionEntriesRequest build() {
            return new GetIpamPrefixListResolverVersionEntriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamPrefixListResolverVersionEntriesRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPrefixListResolverId(String var1);

        public Builder ipamPrefixListResolverVersion(Long var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

