/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RepairAction {
    REPLACE("Replace"),
    REBOOT("Reboot"),
    NO_ACTION("NoAction"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RepairAction> VALUE_MAP;
    private final String value;

    private RepairAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RepairAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RepairAction> knownValues() {
        EnumSet<RepairAction> knownValues = EnumSet.allOf(RepairAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RepairAction.class, RepairAction::toString);
    }
}

