/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscription;
import software.amazon.awssdk.services.eks.model.ListEksAnywhereSubscriptionsRequest;
import software.amazon.awssdk.services.eks.model.ListEksAnywhereSubscriptionsResponse;

public class ListEksAnywhereSubscriptionsIterable
implements SdkIterable<ListEksAnywhereSubscriptionsResponse> {
    private final EksClient client;
    private final ListEksAnywhereSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEksAnywhereSubscriptionsIterable(EksClient client, ListEksAnywhereSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEksAnywhereSubscriptionsResponseFetcher();
    }

    public Iterator<ListEksAnywhereSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EksAnywhereSubscription> subscriptions() {
        Function<ListEksAnywhereSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEksAnywhereSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListEksAnywhereSubscriptionsResponse> {
        private ListEksAnywhereSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEksAnywhereSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEksAnywhereSubscriptionsResponse nextPage(ListEksAnywhereSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListEksAnywhereSubscriptionsIterable.this.client.listEksAnywhereSubscriptions(ListEksAnywhereSubscriptionsIterable.this.firstRequest);
            }
            return ListEksAnywhereSubscriptionsIterable.this.client.listEksAnywhereSubscriptions((ListEksAnywhereSubscriptionsRequest)((Object)ListEksAnywhereSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

