/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListPodIdentityAssociationsRequest;
import software.amazon.awssdk.services.eks.model.ListPodIdentityAssociationsResponse;
import software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummary;

public class ListPodIdentityAssociationsIterable
implements SdkIterable<ListPodIdentityAssociationsResponse> {
    private final EksClient client;
    private final ListPodIdentityAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPodIdentityAssociationsIterable(EksClient client, ListPodIdentityAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPodIdentityAssociationsResponseFetcher();
    }

    public Iterator<ListPodIdentityAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PodIdentityAssociationSummary> associations() {
        Function<ListPodIdentityAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPodIdentityAssociationsResponseFetcher
    implements SyncPageFetcher<ListPodIdentityAssociationsResponse> {
        private ListPodIdentityAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPodIdentityAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPodIdentityAssociationsResponse nextPage(ListPodIdentityAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListPodIdentityAssociationsIterable.this.client.listPodIdentityAssociations(ListPodIdentityAssociationsIterable.this.firstRequest);
            }
            return ListPodIdentityAssociationsIterable.this.client.listPodIdentityAssociations((ListPodIdentityAssociationsRequest)((Object)ListPodIdentityAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

