/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlatformStatus {
    CREATING("Creating"),
    FAILED("Failed"),
    READY("Ready"),
    DELETING("Deleting"),
    DELETED("Deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlatformStatus> VALUE_MAP;
    private final String value;

    private PlatformStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlatformStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlatformStatus> knownValues() {
        EnumSet<PlatformStatus> knownValues = EnumSet.allOf(PlatformStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlatformStatus.class, PlatformStatus::toString);
    }
}

