/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEndpointsRequest
extends EventBridgeRequest
implements ToCopyableBuilder<Builder, ListEndpointsRequest> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamePrefix").getter(ListEndpointsRequest.getter(ListEndpointsRequest::namePrefix)).setter(ListEndpointsRequest.setter(Builder::namePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(ListEndpointsRequest.getter(ListEndpointsRequest::homeRegion)).setter(ListEndpointsRequest.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEndpointsRequest.getter(ListEndpointsRequest::nextToken)).setter(ListEndpointsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEndpointsRequest.getter(ListEndpointsRequest::maxResults)).setter(ListEndpointsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD, HOME_REGION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEndpointsRequest.memberNameToFieldInitializer();
    private final String namePrefix;
    private final String homeRegion;
    private final String nextToken;
    private final Integer maxResults;

    private ListEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.namePrefix = builder.namePrefix;
        this.homeRegion = builder.homeRegion;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String namePrefix() {
        return this.namePrefix;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsRequest)) {
            return false;
        }
        ListEndpointsRequest other = (ListEndpointsRequest)((Object)obj);
        return Objects.equals(this.namePrefix(), other.namePrefix()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListEndpointsRequest").add("NamePrefix", (Object)this.namePrefix()).add("HomeRegion", (Object)this.homeRegion()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamePrefix": {
                return Optional.ofNullable(clazz.cast(this.namePrefix()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsRequest, T> g) {
        return obj -> g.apply((ListEndpointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeRequest.BuilderImpl
    implements Builder {
        private String namePrefix;
        private String homeRegion;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsRequest model) {
            super(model);
            this.namePrefix(model.namePrefix);
            this.homeRegion(model.homeRegion);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEndpointsRequest build() {
            return new ListEndpointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEndpointsRequest> {
        public Builder namePrefix(String var1);

        public Builder homeRegion(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

