/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleState {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS("ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleState> VALUE_MAP;
    private final String value;

    private RuleState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleState> knownValues() {
        EnumSet<RuleState> knownValues = EnumSet.allOf(RuleState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleState.class, RuleState::toString);
    }
}

