/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for EventBridge to use when invoking the resource endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectionResourceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeConnectionResourceParameters.Builder, DescribeConnectionResourceParameters> {
    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceConfigurationArn")
            .getter(getter(DescribeConnectionResourceParameters::resourceConfigurationArn))
            .setter(setter(Builder::resourceConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationArn").build())
            .build();

    private static final SdkField<String> RESOURCE_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceAssociationArn").getter(getter(DescribeConnectionResourceParameters::resourceAssociationArn))
            .setter(setter(Builder::resourceAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAssociationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_CONFIGURATION_ARN_FIELD, RESOURCE_ASSOCIATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceConfigurationArn;

    private final String resourceAssociationArn;

    private DescribeConnectionResourceParameters(BuilderImpl builder) {
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.resourceAssociationArn = builder.resourceAssociationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration for the private API.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration for the private API.
     */
    public final String resourceConfigurationArn() {
        return resourceConfigurationArn;
    }

    /**
     * <p>
     * For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created
     * between the connection and the private API's resource configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html#connection-private-snra">
     * Managing service network resource associations for connections</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     * 
     * @return For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge
     *         created between the connection and the private API's resource configuration.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html#connection-private-snra"
     *         > Managing service network resource associations for connections</a> in the <i> <i>Amazon EventBridge
     *         User Guide</i> </i>.
     */
    public final String resourceAssociationArn() {
        return resourceAssociationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAssociationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionResourceParameters)) {
            return false;
        }
        DescribeConnectionResourceParameters other = (DescribeConnectionResourceParameters) obj;
        return Objects.equals(resourceConfigurationArn(), other.resourceConfigurationArn())
                && Objects.equals(resourceAssociationArn(), other.resourceAssociationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectionResourceParameters")
                .add("ResourceConfigurationArn", resourceConfigurationArn())
                .add("ResourceAssociationArn", resourceAssociationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceConfigurationArn":
            return Optional.ofNullable(clazz.cast(resourceConfigurationArn()));
        case "ResourceAssociationArn":
            return Optional.ofNullable(clazz.cast(resourceAssociationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("ResourceAssociationArn", RESOURCE_ASSOCIATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionResourceParameters, T> g) {
        return obj -> g.apply((DescribeConnectionResourceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeConnectionResourceParameters> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration for the private API.
         * </p>
         * 
         * @param resourceConfigurationArn
         *        The Amazon Resource Name (ARN) of the resource configuration for the private API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArn(String resourceConfigurationArn);

        /**
         * <p>
         * For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge
         * created between the connection and the private API's resource configuration.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html#connection-private-snra">
         * Managing service network resource associations for connections</a> in the <i> <i>Amazon EventBridge User
         * Guide</i> </i>.
         * </p>
         * 
         * @param resourceAssociationArn
         *        For connections to private APIs, the Amazon Resource Name (ARN) of the resource association
         *        EventBridge created between the connection and the private API's resource configuration.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html#connection-private-snra"
         *        > Managing service network resource associations for connections</a> in the <i> <i>Amazon EventBridge
         *        User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAssociationArn(String resourceAssociationArn);
    }

    static final class BuilderImpl implements Builder {
        private String resourceConfigurationArn;

        private String resourceAssociationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionResourceParameters model) {
            resourceConfigurationArn(model.resourceConfigurationArn);
            resourceAssociationArn(model.resourceAssociationArn);
        }

        public final String getResourceConfigurationArn() {
            return resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getResourceAssociationArn() {
            return resourceAssociationArn;
        }

        public final void setResourceAssociationArn(String resourceAssociationArn) {
            this.resourceAssociationArn = resourceAssociationArn;
        }

        @Override
        public final Builder resourceAssociationArn(String resourceAssociationArn) {
            this.resourceAssociationArn = resourceAssociationArn;
            return this;
        }

        @Override
        public DescribeConnectionResourceParameters build() {
            return new DescribeConnectionResourceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
