/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionRequest extends EventBridgeRequest implements
        ToCopyableBuilder<UpdateConnectionRequest.Builder, UpdateConnectionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateConnectionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateConnectionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationType").getter(getter(UpdateConnectionRequest::authorizationTypeAsString))
            .setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationType").build()).build();

    private static final SdkField<UpdateConnectionAuthRequestParameters> AUTH_PARAMETERS_FIELD = SdkField
            .<UpdateConnectionAuthRequestParameters> builder(MarshallingType.SDK_POJO).memberName("AuthParameters")
            .getter(getter(UpdateConnectionRequest::authParameters)).setter(setter(Builder::authParameters))
            .constructor(UpdateConnectionAuthRequestParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthParameters").build()).build();

    private static final SdkField<ConnectivityResourceParameters> INVOCATION_CONNECTIVITY_PARAMETERS_FIELD = SdkField
            .<ConnectivityResourceParameters> builder(MarshallingType.SDK_POJO)
            .memberName("InvocationConnectivityParameters")
            .getter(getter(UpdateConnectionRequest::invocationConnectivityParameters))
            .setter(setter(Builder::invocationConnectivityParameters))
            .constructor(ConnectivityResourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationConnectivityParameters")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            AUTHORIZATION_TYPE_FIELD, AUTH_PARAMETERS_FIELD, INVOCATION_CONNECTIVITY_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String authorizationType;

    private final UpdateConnectionAuthRequestParameters authParameters;

    private final ConnectivityResourceParameters invocationConnectivityParameters;

    private UpdateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.authorizationType = builder.authorizationType;
        this.authParameters = builder.authParameters;
        this.invocationConnectivityParameters = builder.invocationConnectivityParameters;
    }

    /**
     * <p>
     * The name of the connection to update.
     * </p>
     * 
     * @return The name of the connection to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the connection.
     * </p>
     * 
     * @return A description for the connection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of authorization to use for the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link ConnectionAuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The type of authorization to use for the connection.
     * @see ConnectionAuthorizationType
     */
    public final ConnectionAuthorizationType authorizationType() {
        return ConnectionAuthorizationType.fromValue(authorizationType);
    }

    /**
     * <p>
     * The type of authorization to use for the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link ConnectionAuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The type of authorization to use for the connection.
     * @see ConnectionAuthorizationType
     */
    public final String authorizationTypeAsString() {
        return authorizationType;
    }

    /**
     * <p>
     * The authorization parameters to use for the connection.
     * </p>
     * 
     * @return The authorization parameters to use for the connection.
     */
    public final UpdateConnectionAuthRequestParameters authParameters() {
        return authParameters;
    }

    /**
     * <p>
     * For connections to private APIs, the parameters to use for invoking the API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private
     * APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     * </p>
     * 
     * @return For connections to private APIs, the parameters to use for invoking the API.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to
     *         private APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     */
    public final ConnectivityResourceParameters invocationConnectivityParameters() {
        return invocationConnectivityParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authParameters());
        hashCode = 31 * hashCode + Objects.hashCode(invocationConnectivityParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionRequest)) {
            return false;
        }
        UpdateConnectionRequest other = (UpdateConnectionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(authorizationTypeAsString(), other.authorizationTypeAsString())
                && Objects.equals(authParameters(), other.authParameters())
                && Objects.equals(invocationConnectivityParameters(), other.invocationConnectivityParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionRequest").add("Name", name()).add("Description", description())
                .add("AuthorizationType", authorizationTypeAsString()).add("AuthParameters", authParameters())
                .add("InvocationConnectivityParameters", invocationConnectivityParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AuthorizationType":
            return Optional.ofNullable(clazz.cast(authorizationTypeAsString()));
        case "AuthParameters":
            return Optional.ofNullable(clazz.cast(authParameters()));
        case "InvocationConnectivityParameters":
            return Optional.ofNullable(clazz.cast(invocationConnectivityParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AuthorizationType", AUTHORIZATION_TYPE_FIELD);
        map.put("AuthParameters", AUTH_PARAMETERS_FIELD);
        map.put("InvocationConnectivityParameters", INVOCATION_CONNECTIVITY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectionRequest> {
        /**
         * <p>
         * The name of the connection to update.
         * </p>
         * 
         * @param name
         *        The name of the connection to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the connection.
         * </p>
         * 
         * @param description
         *        A description for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of authorization to use for the connection.
         * </p>
         * 
         * @param authorizationType
         *        The type of authorization to use for the connection.
         * @see ConnectionAuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthorizationType
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * The type of authorization to use for the connection.
         * </p>
         * 
         * @param authorizationType
         *        The type of authorization to use for the connection.
         * @see ConnectionAuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthorizationType
         */
        Builder authorizationType(ConnectionAuthorizationType authorizationType);

        /**
         * <p>
         * The authorization parameters to use for the connection.
         * </p>
         * 
         * @param authParameters
         *        The authorization parameters to use for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authParameters(UpdateConnectionAuthRequestParameters authParameters);

        /**
         * <p>
         * The authorization parameters to use for the connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateConnectionAuthRequestParameters.Builder} avoiding the need to create one manually via
         * {@link UpdateConnectionAuthRequestParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateConnectionAuthRequestParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #authParameters(UpdateConnectionAuthRequestParameters)}.
         * 
         * @param authParameters
         *        a consumer that will call methods on {@link UpdateConnectionAuthRequestParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authParameters(UpdateConnectionAuthRequestParameters)
         */
        default Builder authParameters(Consumer<UpdateConnectionAuthRequestParameters.Builder> authParameters) {
            return authParameters(UpdateConnectionAuthRequestParameters.builder().applyMutation(authParameters).build());
        }

        /**
         * <p>
         * For connections to private APIs, the parameters to use for invoking the API.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private
         * APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * </p>
         * 
         * @param invocationConnectivityParameters
         *        For connections to private APIs, the parameters to use for invoking the API.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to
         *        private APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationConnectivityParameters(ConnectivityResourceParameters invocationConnectivityParameters);

        /**
         * <p>
         * For connections to private APIs, the parameters to use for invoking the API.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private
         * APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectivityResourceParameters.Builder}
         * avoiding the need to create one manually via {@link ConnectivityResourceParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectivityResourceParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #invocationConnectivityParameters(ConnectivityResourceParameters)}.
         * 
         * @param invocationConnectivityParameters
         *        a consumer that will call methods on {@link ConnectivityResourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationConnectivityParameters(ConnectivityResourceParameters)
         */
        default Builder invocationConnectivityParameters(
                Consumer<ConnectivityResourceParameters.Builder> invocationConnectivityParameters) {
            return invocationConnectivityParameters(ConnectivityResourceParameters.builder()
                    .applyMutation(invocationConnectivityParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String authorizationType;

        private UpdateConnectionAuthRequestParameters authParameters;

        private ConnectivityResourceParameters invocationConnectivityParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            authorizationType(model.authorizationType);
            authParameters(model.authParameters);
            invocationConnectivityParameters(model.invocationConnectivityParameters);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(ConnectionAuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final UpdateConnectionAuthRequestParameters.Builder getAuthParameters() {
            return authParameters != null ? authParameters.toBuilder() : null;
        }

        public final void setAuthParameters(UpdateConnectionAuthRequestParameters.BuilderImpl authParameters) {
            this.authParameters = authParameters != null ? authParameters.build() : null;
        }

        @Override
        public final Builder authParameters(UpdateConnectionAuthRequestParameters authParameters) {
            this.authParameters = authParameters;
            return this;
        }

        public final ConnectivityResourceParameters.Builder getInvocationConnectivityParameters() {
            return invocationConnectivityParameters != null ? invocationConnectivityParameters.toBuilder() : null;
        }

        public final void setInvocationConnectivityParameters(
                ConnectivityResourceParameters.BuilderImpl invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters != null ? invocationConnectivityParameters
                    .build() : null;
        }

        @Override
        public final Builder invocationConnectivityParameters(ConnectivityResourceParameters invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionRequest build() {
            return new UpdateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
