/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.globalaccelerator.model.Accelerator;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAcceleratorResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, CreateAcceleratorResponse> {
    private static final SdkField<Accelerator> ACCELERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Accelerator").getter(CreateAcceleratorResponse.getter(CreateAcceleratorResponse::accelerator)).setter(CreateAcceleratorResponse.setter(Builder::accelerator)).constructor(Accelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_FIELD));
    private final Accelerator accelerator;

    private CreateAcceleratorResponse(BuilderImpl builder) {
        super(builder);
        this.accelerator = builder.accelerator;
    }

    public final Accelerator accelerator() {
        return this.accelerator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accelerator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAcceleratorResponse)) {
            return false;
        }
        CreateAcceleratorResponse other = (CreateAcceleratorResponse)((Object)obj);
        return Objects.equals(this.accelerator(), other.accelerator());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAcceleratorResponse").add("Accelerator", (Object)this.accelerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accelerator": {
                return Optional.ofNullable(clazz.cast(this.accelerator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAcceleratorResponse, T> g) {
        return obj -> g.apply((CreateAcceleratorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private Accelerator accelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAcceleratorResponse model) {
            super(model);
            this.accelerator(model.accelerator);
        }

        public final Accelerator.Builder getAccelerator() {
            return this.accelerator != null ? this.accelerator.toBuilder() : null;
        }

        public final void setAccelerator(Accelerator.BuilderImpl accelerator) {
            this.accelerator = accelerator != null ? accelerator.build() : null;
        }

        @Override
        public final Builder accelerator(Accelerator accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        @Override
        public CreateAcceleratorResponse build() {
            return new CreateAcceleratorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAcceleratorResponse> {
        public Builder accelerator(Accelerator var1);

        default public Builder accelerator(Consumer<Accelerator.Builder> accelerator) {
            return this.accelerator((Accelerator)((Accelerator.Builder)Accelerator.builder().applyMutation(accelerator)).build());
        }
    }
}

