/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomRoutingPortMappingsByDestinationRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, ListCustomRoutingPortMappingsByDestinationRequest> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(ListCustomRoutingPortMappingsByDestinationRequest.getter(ListCustomRoutingPortMappingsByDestinationRequest::endpointId)).setter(ListCustomRoutingPortMappingsByDestinationRequest.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<String> DESTINATION_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationAddress").getter(ListCustomRoutingPortMappingsByDestinationRequest.getter(ListCustomRoutingPortMappingsByDestinationRequest::destinationAddress)).setter(ListCustomRoutingPortMappingsByDestinationRequest.setter(Builder::destinationAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCustomRoutingPortMappingsByDestinationRequest.getter(ListCustomRoutingPortMappingsByDestinationRequest::maxResults)).setter(ListCustomRoutingPortMappingsByDestinationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomRoutingPortMappingsByDestinationRequest.getter(ListCustomRoutingPortMappingsByDestinationRequest::nextToken)).setter(ListCustomRoutingPortMappingsByDestinationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD, DESTINATION_ADDRESS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String endpointId;
    private final String destinationAddress;
    private final Integer maxResults;
    private final String nextToken;

    private ListCustomRoutingPortMappingsByDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.endpointId = builder.endpointId;
        this.destinationAddress = builder.destinationAddress;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final String destinationAddress() {
        return this.destinationAddress;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingPortMappingsByDestinationRequest)) {
            return false;
        }
        ListCustomRoutingPortMappingsByDestinationRequest other = (ListCustomRoutingPortMappingsByDestinationRequest)((Object)obj);
        return Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.destinationAddress(), other.destinationAddress()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomRoutingPortMappingsByDestinationRequest").add("EndpointId", (Object)this.endpointId()).add("DestinationAddress", (Object)this.destinationAddress()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "DestinationAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationAddress()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingPortMappingsByDestinationRequest, T> g) {
        return obj -> g.apply((ListCustomRoutingPortMappingsByDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String endpointId;
        private String destinationAddress;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingPortMappingsByDestinationRequest model) {
            super(model);
            this.endpointId(model.endpointId);
            this.destinationAddress(model.destinationAddress);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getDestinationAddress() {
            return this.destinationAddress;
        }

        public final void setDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
        }

        @Override
        public final Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomRoutingPortMappingsByDestinationRequest build() {
            return new ListCustomRoutingPortMappingsByDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomRoutingPortMappingsByDestinationRequest> {
        public Builder endpointId(String var1);

        public Builder destinationAddress(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

