/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTriggersResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetTriggersResponse.Builder, BatchGetTriggersResponse> {
    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField
            .<List<Trigger>> builder(MarshallingType.LIST)
            .memberName("Triggers")
            .getter(getter(BatchGetTriggersResponse::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TRIGGERS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TriggersNotFound")
            .getter(getter(BatchGetTriggersResponse::triggersNotFound))
            .setter(setter(Builder::triggersNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggersNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGERS_FIELD,
            TRIGGERS_NOT_FOUND_FIELD));

    private final List<Trigger> triggers;

    private final List<String> triggersNotFound;

    private BatchGetTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.triggers = builder.triggers;
        this.triggersNotFound = builder.triggersNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of trigger definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return A list of trigger definitions.
     */
    public final List<Trigger> triggers() {
        return triggers;
    }

    /**
     * For responses, this returns true if the service returned a value for the TriggersNotFound property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTriggersNotFound() {
        return triggersNotFound != null && !(triggersNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of triggers not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggersNotFound} method.
     * </p>
     * 
     * @return A list of names of triggers not found.
     */
    public final List<String> triggersNotFound() {
        return triggersNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggersNotFound() ? triggersNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTriggersResponse)) {
            return false;
        }
        BatchGetTriggersResponse other = (BatchGetTriggersResponse) obj;
        return hasTriggers() == other.hasTriggers() && Objects.equals(triggers(), other.triggers())
                && hasTriggersNotFound() == other.hasTriggersNotFound()
                && Objects.equals(triggersNotFound(), other.triggersNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetTriggersResponse").add("Triggers", hasTriggers() ? triggers() : null)
                .add("TriggersNotFound", hasTriggersNotFound() ? triggersNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "TriggersNotFound":
            return Optional.ofNullable(clazz.cast(triggersNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTriggersResponse, T> g) {
        return obj -> g.apply((BatchGetTriggersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetTriggersResponse> {
        /**
         * <p>
         * A list of trigger definitions.
         * </p>
         * 
         * @param triggers
         *        A list of trigger definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<Trigger> triggers);

        /**
         * <p>
         * A list of trigger definitions.
         * </p>
         * 
         * @param triggers
         *        A list of trigger definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Trigger... triggers);

        /**
         * <p>
         * A list of trigger definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Trigger>.Builder} avoiding the need to
         * create one manually via {@link List<Trigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Trigger>.Builder#build()} is called immediately and its
         * result is passed to {@link #triggers(List<Trigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<Trigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<Trigger>)
         */
        Builder triggers(Consumer<Trigger.Builder>... triggers);

        /**
         * <p>
         * A list of names of triggers not found.
         * </p>
         * 
         * @param triggersNotFound
         *        A list of names of triggers not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggersNotFound(Collection<String> triggersNotFound);

        /**
         * <p>
         * A list of names of triggers not found.
         * </p>
         * 
         * @param triggersNotFound
         *        A list of names of triggers not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggersNotFound(String... triggersNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private List<String> triggersNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTriggersResponse model) {
            super(model);
            triggers(model.triggers);
            triggersNotFound(model.triggersNotFound);
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        @Transient
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggers(Trigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> Trigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTriggersNotFound() {
            if (triggersNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return triggersNotFound;
        }

        public final void setTriggersNotFound(Collection<String> triggersNotFound) {
            this.triggersNotFound = TriggerNameListCopier.copy(triggersNotFound);
        }

        @Override
        @Transient
        public final Builder triggersNotFound(Collection<String> triggersNotFound) {
            this.triggersNotFound = TriggerNameListCopier.copy(triggersNotFound);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggersNotFound(String... triggersNotFound) {
            triggersNotFound(Arrays.asList(triggersNotFound));
            return this;
        }

        @Override
        public BatchGetTriggersResponse build() {
            return new BatchGetTriggersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
