/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a crawl in the workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Crawl implements SdkPojo, Serializable, ToCopyableBuilder<Crawl.Builder, Crawl> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Crawl::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(Crawl::startedOn)).setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(Crawl::completedOn)).setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(Crawl::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroup").getter(getter(Crawl::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()).build();

    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStream").getter(getter(Crawl::logStream)).setter(setter(Builder::logStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STARTED_ON_FIELD,
            COMPLETED_ON_FIELD, ERROR_MESSAGE_FIELD, LOG_GROUP_FIELD, LOG_STREAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final Instant startedOn;

    private final Instant completedOn;

    private final String errorMessage;

    private final String logGroup;

    private final String logStream;

    private Crawl(BuilderImpl builder) {
        this.state = builder.state;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.errorMessage = builder.errorMessage;
        this.logGroup = builder.logGroup;
        this.logStream = builder.logStream;
    }

    /**
     * <p>
     * The state of the crawler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CrawlState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the crawler.
     * @see CrawlState
     */
    public final CrawlState state() {
        return CrawlState.fromValue(state);
    }

    /**
     * <p>
     * The state of the crawler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CrawlState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the crawler.
     * @see CrawlState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time on which the crawl started.
     * </p>
     * 
     * @return The date and time on which the crawl started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * The date and time on which the crawl completed.
     * </p>
     * 
     * @return The date and time on which the crawl completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * The error message associated with the crawl.
     * </p>
     * 
     * @return The error message associated with the crawl.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The log group associated with the crawl.
     * </p>
     * 
     * @return The log group associated with the crawl.
     */
    public final String logGroup() {
        return logGroup;
    }

    /**
     * <p>
     * The log stream associated with the crawl.
     * </p>
     * 
     * @return The log stream associated with the crawl.
     */
    public final String logStream() {
        return logStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(logStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Crawl)) {
            return false;
        }
        Crawl other = (Crawl) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(startedOn(), other.startedOn())
                && Objects.equals(completedOn(), other.completedOn()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(logGroup(), other.logGroup()) && Objects.equals(logStream(), other.logStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Crawl").add("State", stateAsString()).add("StartedOn", startedOn())
                .add("CompletedOn", completedOn()).add("ErrorMessage", errorMessage()).add("LogGroup", logGroup())
                .add("LogStream", logStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LogGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        case "LogStream":
            return Optional.ofNullable(clazz.cast(logStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Crawl, T> g) {
        return obj -> g.apply((Crawl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Crawl> {
        /**
         * <p>
         * The state of the crawler.
         * </p>
         * 
         * @param state
         *        The state of the crawler.
         * @see CrawlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the crawler.
         * </p>
         * 
         * @param state
         *        The state of the crawler.
         * @see CrawlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlState
         */
        Builder state(CrawlState state);

        /**
         * <p>
         * The date and time on which the crawl started.
         * </p>
         * 
         * @param startedOn
         *        The date and time on which the crawl started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * The date and time on which the crawl completed.
         * </p>
         * 
         * @param completedOn
         *        The date and time on which the crawl completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * The error message associated with the crawl.
         * </p>
         * 
         * @param errorMessage
         *        The error message associated with the crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The log group associated with the crawl.
         * </p>
         * 
         * @param logGroup
         *        The log group associated with the crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);

        /**
         * <p>
         * The log stream associated with the crawl.
         * </p>
         * 
         * @param logStream
         *        The log stream associated with the crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStream(String logStream);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private Instant startedOn;

        private Instant completedOn;

        private String errorMessage;

        private String logGroup;

        private String logStream;

        private BuilderImpl() {
        }

        private BuilderImpl(Crawl model) {
            state(model.state);
            startedOn(model.startedOn);
            completedOn(model.completedOn);
            errorMessage(model.errorMessage);
            logGroup(model.logGroup);
            logStream(model.logStream);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(CrawlState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        @Transient
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        @Transient
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getLogGroup() {
            return logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        @Transient
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final String getLogStream() {
            return logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        @Transient
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        @Override
        public Crawl build() {
            return new Crawl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
