/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePartitionRequest extends GlueRequest implements
        ToCopyableBuilder<CreatePartitionRequest.Builder, CreatePartitionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(CreatePartitionRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreatePartitionRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(CreatePartitionRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<PartitionInput> PARTITION_INPUT_FIELD = SdkField
            .<PartitionInput> builder(MarshallingType.SDK_POJO).memberName("PartitionInput")
            .getter(getter(CreatePartitionRequest::partitionInput)).setter(setter(Builder::partitionInput))
            .constructor(PartitionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, PARTITION_INPUT_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final PartitionInput partitionInput;

    private CreatePartitionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.partitionInput = builder.partitionInput;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the catalog in which the partition is to be created.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the catalog in which the partition is to be created.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the metadata database in which the partition is to be created.
     * </p>
     * 
     * @return The name of the metadata database in which the partition is to be created.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the metadata table in which the partition is to be created.
     * </p>
     * 
     * @return The name of the metadata table in which the partition is to be created.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A <code>PartitionInput</code> structure defining the partition to be created.
     * </p>
     * 
     * @return A <code>PartitionInput</code> structure defining the partition to be created.
     */
    public final PartitionInput partitionInput() {
        return partitionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(partitionInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartitionRequest)) {
            return false;
        }
        CreatePartitionRequest other = (CreatePartitionRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(partitionInput(), other.partitionInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePartitionRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("PartitionInput", partitionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "PartitionInput":
            return Optional.ofNullable(clazz.cast(partitionInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePartitionRequest, T> g) {
        return obj -> g.apply((CreatePartitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePartitionRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the catalog in which the partition is to be created.
         * </p>
         * 
         * @param catalogId
         *        The Amazon Web Services account ID of the catalog in which the partition is to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the metadata database in which the partition is to be created.
         * </p>
         * 
         * @param databaseName
         *        The name of the metadata database in which the partition is to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the metadata table in which the partition is to be created.
         * </p>
         * 
         * @param tableName
         *        The name of the metadata table in which the partition is to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A <code>PartitionInput</code> structure defining the partition to be created.
         * </p>
         * 
         * @param partitionInput
         *        A <code>PartitionInput</code> structure defining the partition to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionInput(PartitionInput partitionInput);

        /**
         * <p>
         * A <code>PartitionInput</code> structure defining the partition to be created.
         * </p>
         * This is a convenience that creates an instance of the {@link PartitionInput.Builder} avoiding the need to
         * create one manually via {@link PartitionInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link PartitionInput.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionInput(PartitionInput)}.
         * 
         * @param partitionInput
         *        a consumer that will call methods on {@link PartitionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionInput(PartitionInput)
         */
        default Builder partitionInput(Consumer<PartitionInput.Builder> partitionInput) {
            return partitionInput(PartitionInput.builder().applyMutation(partitionInput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private PartitionInput partitionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePartitionRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            partitionInput(model.partitionInput);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final PartitionInput.Builder getPartitionInput() {
            return partitionInput != null ? partitionInput.toBuilder() : null;
        }

        public final void setPartitionInput(PartitionInput.BuilderImpl partitionInput) {
            this.partitionInput = partitionInput != null ? partitionInput.build() : null;
        }

        @Override
        @Transient
        public final Builder partitionInput(PartitionInput partitionInput) {
            this.partitionInput = partitionInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePartitionRequest build() {
            return new CreatePartitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
