/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUnfilteredPartitionMetadataResponse extends GlueResponse implements
        ToCopyableBuilder<GetUnfilteredPartitionMetadataResponse.Builder, GetUnfilteredPartitionMetadataResponse> {
    private static final SdkField<Partition> PARTITION_FIELD = SdkField.<Partition> builder(MarshallingType.SDK_POJO)
            .memberName("Partition").getter(getter(GetUnfilteredPartitionMetadataResponse::partition))
            .setter(setter(Builder::partition)).constructor(Partition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partition").build()).build();

    private static final SdkField<List<String>> AUTHORIZED_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedColumns")
            .getter(getter(GetUnfilteredPartitionMetadataResponse::authorizedColumns))
            .setter(setter(Builder::authorizedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_REGISTERED_WITH_LAKE_FORMATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRegisteredWithLakeFormation")
            .getter(getter(GetUnfilteredPartitionMetadataResponse::isRegisteredWithLakeFormation))
            .setter(setter(Builder::isRegisteredWithLakeFormation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRegisteredWithLakeFormation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_FIELD,
            AUTHORIZED_COLUMNS_FIELD, IS_REGISTERED_WITH_LAKE_FORMATION_FIELD));

    private final Partition partition;

    private final List<String> authorizedColumns;

    private final Boolean isRegisteredWithLakeFormation;

    private GetUnfilteredPartitionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.partition = builder.partition;
        this.authorizedColumns = builder.authorizedColumns;
        this.isRegisteredWithLakeFormation = builder.isRegisteredWithLakeFormation;
    }

    /**
     * Returns the value of the Partition property for this object.
     * 
     * @return The value of the Partition property for this object.
     */
    public final Partition partition() {
        return partition;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedColumns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedColumns() {
        return authorizedColumns != null && !(authorizedColumns instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AuthorizedColumns property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedColumns} method.
     * </p>
     * 
     * @return The value of the AuthorizedColumns property for this object.
     */
    public final List<String> authorizedColumns() {
        return authorizedColumns;
    }

    /**
     * Returns the value of the IsRegisteredWithLakeFormation property for this object.
     * 
     * @return The value of the IsRegisteredWithLakeFormation property for this object.
     */
    public final Boolean isRegisteredWithLakeFormation() {
        return isRegisteredWithLakeFormation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(partition());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedColumns() ? authorizedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isRegisteredWithLakeFormation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredPartitionMetadataResponse)) {
            return false;
        }
        GetUnfilteredPartitionMetadataResponse other = (GetUnfilteredPartitionMetadataResponse) obj;
        return Objects.equals(partition(), other.partition()) && hasAuthorizedColumns() == other.hasAuthorizedColumns()
                && Objects.equals(authorizedColumns(), other.authorizedColumns())
                && Objects.equals(isRegisteredWithLakeFormation(), other.isRegisteredWithLakeFormation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUnfilteredPartitionMetadataResponse").add("Partition", partition())
                .add("AuthorizedColumns", hasAuthorizedColumns() ? authorizedColumns() : null)
                .add("IsRegisteredWithLakeFormation", isRegisteredWithLakeFormation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Partition":
            return Optional.ofNullable(clazz.cast(partition()));
        case "AuthorizedColumns":
            return Optional.ofNullable(clazz.cast(authorizedColumns()));
        case "IsRegisteredWithLakeFormation":
            return Optional.ofNullable(clazz.cast(isRegisteredWithLakeFormation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredPartitionMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredPartitionMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUnfilteredPartitionMetadataResponse> {
        /**
         * Sets the value of the Partition property for this object.
         *
         * @param partition
         *        The new value for the Partition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partition(Partition partition);

        /**
         * Sets the value of the Partition property for this object.
         *
         * This is a convenience that creates an instance of the {@link Partition.Builder} avoiding the need to create
         * one manually via {@link Partition#builder()}.
         *
         * When the {@link Consumer} completes, {@link Partition.Builder#build()} is called immediately and its result
         * is passed to {@link #partition(Partition)}.
         * 
         * @param partition
         *        a consumer that will call methods on {@link Partition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partition(Partition)
         */
        default Builder partition(Consumer<Partition.Builder> partition) {
            return partition(Partition.builder().applyMutation(partition).build());
        }

        /**
         * Sets the value of the AuthorizedColumns property for this object.
         *
         * @param authorizedColumns
         *        The new value for the AuthorizedColumns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedColumns(Collection<String> authorizedColumns);

        /**
         * Sets the value of the AuthorizedColumns property for this object.
         *
         * @param authorizedColumns
         *        The new value for the AuthorizedColumns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedColumns(String... authorizedColumns);

        /**
         * Sets the value of the IsRegisteredWithLakeFormation property for this object.
         *
         * @param isRegisteredWithLakeFormation
         *        The new value for the IsRegisteredWithLakeFormation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Partition partition;

        private List<String> authorizedColumns = DefaultSdkAutoConstructList.getInstance();

        private Boolean isRegisteredWithLakeFormation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredPartitionMetadataResponse model) {
            super(model);
            partition(model.partition);
            authorizedColumns(model.authorizedColumns);
            isRegisteredWithLakeFormation(model.isRegisteredWithLakeFormation);
        }

        public final Partition.Builder getPartition() {
            return partition != null ? partition.toBuilder() : null;
        }

        public final void setPartition(Partition.BuilderImpl partition) {
            this.partition = partition != null ? partition.build() : null;
        }

        @Override
        @Transient
        public final Builder partition(Partition partition) {
            this.partition = partition;
            return this;
        }

        public final Collection<String> getAuthorizedColumns() {
            if (authorizedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedColumns;
        }

        public final void setAuthorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
        }

        @Override
        @Transient
        public final Builder authorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder authorizedColumns(String... authorizedColumns) {
            authorizedColumns(Arrays.asList(authorizedColumns));
            return this;
        }

        public final Boolean getIsRegisteredWithLakeFormation() {
            return isRegisteredWithLakeFormation;
        }

        public final void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
        }

        @Override
        @Transient
        public final Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
            return this;
        }

        @Override
        public GetUnfilteredPartitionMetadataResponse build() {
            return new GetUnfilteredPartitionMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
