/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUnfilteredTableMetadataResponse extends GlueResponse implements
        ToCopyableBuilder<GetUnfilteredTableMetadataResponse.Builder, GetUnfilteredTableMetadataResponse> {
    private static final SdkField<Table> TABLE_FIELD = SdkField.<Table> builder(MarshallingType.SDK_POJO).memberName("Table")
            .getter(getter(GetUnfilteredTableMetadataResponse::table)).setter(setter(Builder::table)).constructor(Table::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<List<String>> AUTHORIZED_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedColumns")
            .getter(getter(GetUnfilteredTableMetadataResponse::authorizedColumns))
            .setter(setter(Builder::authorizedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_REGISTERED_WITH_LAKE_FORMATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRegisteredWithLakeFormation")
            .getter(getter(GetUnfilteredTableMetadataResponse::isRegisteredWithLakeFormation))
            .setter(setter(Builder::isRegisteredWithLakeFormation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRegisteredWithLakeFormation")
                    .build()).build();

    private static final SdkField<List<ColumnRowFilter>> CELL_FILTERS_FIELD = SdkField
            .<List<ColumnRowFilter>> builder(MarshallingType.LIST)
            .memberName("CellFilters")
            .getter(getter(GetUnfilteredTableMetadataResponse::cellFilters))
            .setter(setter(Builder::cellFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnRowFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnRowFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_FIELD,
            AUTHORIZED_COLUMNS_FIELD, IS_REGISTERED_WITH_LAKE_FORMATION_FIELD, CELL_FILTERS_FIELD));

    private final Table table;

    private final List<String> authorizedColumns;

    private final Boolean isRegisteredWithLakeFormation;

    private final List<ColumnRowFilter> cellFilters;

    private GetUnfilteredTableMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.table = builder.table;
        this.authorizedColumns = builder.authorizedColumns;
        this.isRegisteredWithLakeFormation = builder.isRegisteredWithLakeFormation;
        this.cellFilters = builder.cellFilters;
    }

    /**
     * Returns the value of the Table property for this object.
     * 
     * @return The value of the Table property for this object.
     */
    public final Table table() {
        return table;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedColumns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedColumns() {
        return authorizedColumns != null && !(authorizedColumns instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AuthorizedColumns property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedColumns} method.
     * </p>
     * 
     * @return The value of the AuthorizedColumns property for this object.
     */
    public final List<String> authorizedColumns() {
        return authorizedColumns;
    }

    /**
     * Returns the value of the IsRegisteredWithLakeFormation property for this object.
     * 
     * @return The value of the IsRegisteredWithLakeFormation property for this object.
     */
    public final Boolean isRegisteredWithLakeFormation() {
        return isRegisteredWithLakeFormation;
    }

    /**
     * For responses, this returns true if the service returned a value for the CellFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCellFilters() {
        return cellFilters != null && !(cellFilters instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the CellFilters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCellFilters} method.
     * </p>
     * 
     * @return The value of the CellFilters property for this object.
     */
    public final List<ColumnRowFilter> cellFilters() {
        return cellFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedColumns() ? authorizedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isRegisteredWithLakeFormation());
        hashCode = 31 * hashCode + Objects.hashCode(hasCellFilters() ? cellFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataResponse)) {
            return false;
        }
        GetUnfilteredTableMetadataResponse other = (GetUnfilteredTableMetadataResponse) obj;
        return Objects.equals(table(), other.table()) && hasAuthorizedColumns() == other.hasAuthorizedColumns()
                && Objects.equals(authorizedColumns(), other.authorizedColumns())
                && Objects.equals(isRegisteredWithLakeFormation(), other.isRegisteredWithLakeFormation())
                && hasCellFilters() == other.hasCellFilters() && Objects.equals(cellFilters(), other.cellFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUnfilteredTableMetadataResponse").add("Table", table())
                .add("AuthorizedColumns", hasAuthorizedColumns() ? authorizedColumns() : null)
                .add("IsRegisteredWithLakeFormation", isRegisteredWithLakeFormation())
                .add("CellFilters", hasCellFilters() ? cellFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "AuthorizedColumns":
            return Optional.ofNullable(clazz.cast(authorizedColumns()));
        case "IsRegisteredWithLakeFormation":
            return Optional.ofNullable(clazz.cast(isRegisteredWithLakeFormation()));
        case "CellFilters":
            return Optional.ofNullable(clazz.cast(cellFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredTableMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredTableMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUnfilteredTableMetadataResponse> {
        /**
         * Sets the value of the Table property for this object.
         *
         * @param table
         *        The new value for the Table property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(Table table);

        /**
         * Sets the value of the Table property for this object.
         *
         * This is a convenience that creates an instance of the {@link Table.Builder} avoiding the need to create one
         * manually via {@link Table#builder()}.
         *
         * When the {@link Consumer} completes, {@link Table.Builder#build()} is called immediately and its result is
         * passed to {@link #table(Table)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link Table.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(Table)
         */
        default Builder table(Consumer<Table.Builder> table) {
            return table(Table.builder().applyMutation(table).build());
        }

        /**
         * Sets the value of the AuthorizedColumns property for this object.
         *
         * @param authorizedColumns
         *        The new value for the AuthorizedColumns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedColumns(Collection<String> authorizedColumns);

        /**
         * Sets the value of the AuthorizedColumns property for this object.
         *
         * @param authorizedColumns
         *        The new value for the AuthorizedColumns property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedColumns(String... authorizedColumns);

        /**
         * Sets the value of the IsRegisteredWithLakeFormation property for this object.
         *
         * @param isRegisteredWithLakeFormation
         *        The new value for the IsRegisteredWithLakeFormation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation);

        /**
         * Sets the value of the CellFilters property for this object.
         *
         * @param cellFilters
         *        The new value for the CellFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellFilters(Collection<ColumnRowFilter> cellFilters);

        /**
         * Sets the value of the CellFilters property for this object.
         *
         * @param cellFilters
         *        The new value for the CellFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellFilters(ColumnRowFilter... cellFilters);

        /**
         * Sets the value of the CellFilters property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<ColumnRowFilter>.Builder} avoiding the need
         * to create one manually via {@link List<ColumnRowFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnRowFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #cellFilters(List<ColumnRowFilter>)}.
         * 
         * @param cellFilters
         *        a consumer that will call methods on {@link List<ColumnRowFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cellFilters(List<ColumnRowFilter>)
         */
        Builder cellFilters(Consumer<ColumnRowFilter.Builder>... cellFilters);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Table table;

        private List<String> authorizedColumns = DefaultSdkAutoConstructList.getInstance();

        private Boolean isRegisteredWithLakeFormation;

        private List<ColumnRowFilter> cellFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredTableMetadataResponse model) {
            super(model);
            table(model.table);
            authorizedColumns(model.authorizedColumns);
            isRegisteredWithLakeFormation(model.isRegisteredWithLakeFormation);
            cellFilters(model.cellFilters);
        }

        public final Table.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(Table.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        @Transient
        public final Builder table(Table table) {
            this.table = table;
            return this;
        }

        public final Collection<String> getAuthorizedColumns() {
            if (authorizedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedColumns;
        }

        public final void setAuthorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
        }

        @Override
        @Transient
        public final Builder authorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder authorizedColumns(String... authorizedColumns) {
            authorizedColumns(Arrays.asList(authorizedColumns));
            return this;
        }

        public final Boolean getIsRegisteredWithLakeFormation() {
            return isRegisteredWithLakeFormation;
        }

        public final void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
        }

        @Override
        @Transient
        public final Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
            return this;
        }

        public final List<ColumnRowFilter.Builder> getCellFilters() {
            List<ColumnRowFilter.Builder> result = ColumnRowFilterListCopier.copyToBuilder(this.cellFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellFilters(Collection<ColumnRowFilter.BuilderImpl> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copyFromBuilder(cellFilters);
        }

        @Override
        @Transient
        public final Builder cellFilters(Collection<ColumnRowFilter> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copy(cellFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cellFilters(ColumnRowFilter... cellFilters) {
            cellFilters(Arrays.asList(cellFilters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cellFilters(Consumer<ColumnRowFilter.Builder>... cellFilters) {
            cellFilters(Stream.of(cellFilters).map(c -> ColumnRowFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetUnfilteredTableMetadataResponse build() {
            return new GetUnfilteredTableMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
