/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserDefinedFunctionResponse extends GlueResponse implements
        ToCopyableBuilder<GetUserDefinedFunctionResponse.Builder, GetUserDefinedFunctionResponse> {
    private static final SdkField<UserDefinedFunction> USER_DEFINED_FUNCTION_FIELD = SdkField
            .<UserDefinedFunction> builder(MarshallingType.SDK_POJO).memberName("UserDefinedFunction")
            .getter(getter(GetUserDefinedFunctionResponse::userDefinedFunction)).setter(setter(Builder::userDefinedFunction))
            .constructor(UserDefinedFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFunction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DEFINED_FUNCTION_FIELD));

    private final UserDefinedFunction userDefinedFunction;

    private GetUserDefinedFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.userDefinedFunction = builder.userDefinedFunction;
    }

    /**
     * <p>
     * The requested function definition.
     * </p>
     * 
     * @return The requested function definition.
     */
    public final UserDefinedFunction userDefinedFunction() {
        return userDefinedFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userDefinedFunction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserDefinedFunctionResponse)) {
            return false;
        }
        GetUserDefinedFunctionResponse other = (GetUserDefinedFunctionResponse) obj;
        return Objects.equals(userDefinedFunction(), other.userDefinedFunction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUserDefinedFunctionResponse").add("UserDefinedFunction", userDefinedFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserDefinedFunction":
            return Optional.ofNullable(clazz.cast(userDefinedFunction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserDefinedFunctionResponse, T> g) {
        return obj -> g.apply((GetUserDefinedFunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUserDefinedFunctionResponse> {
        /**
         * <p>
         * The requested function definition.
         * </p>
         * 
         * @param userDefinedFunction
         *        The requested function definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFunction(UserDefinedFunction userDefinedFunction);

        /**
         * <p>
         * The requested function definition.
         * </p>
         * This is a convenience that creates an instance of the {@link UserDefinedFunction.Builder} avoiding the need
         * to create one manually via {@link UserDefinedFunction#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserDefinedFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #userDefinedFunction(UserDefinedFunction)}.
         * 
         * @param userDefinedFunction
         *        a consumer that will call methods on {@link UserDefinedFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDefinedFunction(UserDefinedFunction)
         */
        default Builder userDefinedFunction(Consumer<UserDefinedFunction.Builder> userDefinedFunction) {
            return userDefinedFunction(UserDefinedFunction.builder().applyMutation(userDefinedFunction).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private UserDefinedFunction userDefinedFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserDefinedFunctionResponse model) {
            super(model);
            userDefinedFunction(model.userDefinedFunction);
        }

        public final UserDefinedFunction.Builder getUserDefinedFunction() {
            return userDefinedFunction != null ? userDefinedFunction.toBuilder() : null;
        }

        public final void setUserDefinedFunction(UserDefinedFunction.BuilderImpl userDefinedFunction) {
            this.userDefinedFunction = userDefinedFunction != null ? userDefinedFunction.build() : null;
        }

        @Override
        @Transient
        public final Builder userDefinedFunction(UserDefinedFunction userDefinedFunction) {
            this.userDefinedFunction = userDefinedFunction;
            return this;
        }

        @Override
        public GetUserDefinedFunctionResponse build() {
            return new GetUserDefinedFunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
