/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBlueprintsResponse extends GlueResponse implements
        ToCopyableBuilder<ListBlueprintsResponse.Builder, ListBlueprintsResponse> {
    private static final SdkField<List<String>> BLUEPRINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Blueprints")
            .getter(getter(ListBlueprintsResponse::blueprints))
            .setter(setter(Builder::blueprints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blueprints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBlueprintsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> blueprints;

    private final String nextToken;

    private ListBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blueprints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlueprints() {
        return blueprints != null && !(blueprints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of names of blueprints in the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlueprints} method.
     * </p>
     * 
     * @return List of names of blueprints in the account.
     */
    public final List<String> blueprints() {
        return blueprints;
    }

    /**
     * <p>
     * A continuation token, if not all blueprint names have been returned.
     * </p>
     * 
     * @return A continuation token, if not all blueprint names have been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlueprints() ? blueprints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlueprintsResponse)) {
            return false;
        }
        ListBlueprintsResponse other = (ListBlueprintsResponse) obj;
        return hasBlueprints() == other.hasBlueprints() && Objects.equals(blueprints(), other.blueprints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBlueprintsResponse").add("Blueprints", hasBlueprints() ? blueprints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blueprints":
            return Optional.ofNullable(clazz.cast(blueprints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBlueprintsResponse, T> g) {
        return obj -> g.apply((ListBlueprintsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBlueprintsResponse> {
        /**
         * <p>
         * List of names of blueprints in the account.
         * </p>
         * 
         * @param blueprints
         *        List of names of blueprints in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Collection<String> blueprints);

        /**
         * <p>
         * List of names of blueprints in the account.
         * </p>
         * 
         * @param blueprints
         *        List of names of blueprints in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(String... blueprints);

        /**
         * <p>
         * A continuation token, if not all blueprint names have been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all blueprint names have been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<String> blueprints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlueprintsResponse model) {
            super(model);
            blueprints(model.blueprints);
            nextToken(model.nextToken);
        }

        public final Collection<String> getBlueprints() {
            if (blueprints instanceof SdkAutoConstructList) {
                return null;
            }
            return blueprints;
        }

        public final void setBlueprints(Collection<String> blueprints) {
            this.blueprints = BlueprintNamesCopier.copy(blueprints);
        }

        @Override
        @Transient
        public final Builder blueprints(Collection<String> blueprints) {
            this.blueprints = BlueprintNamesCopier.copy(blueprints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blueprints(String... blueprints) {
            blueprints(Arrays.asList(blueprints));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBlueprintsResponse build() {
            return new ListBlueprintsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
