/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTriggersResponse extends GlueResponse implements
        ToCopyableBuilder<ListTriggersResponse.Builder, ListTriggersResponse> {
    private static final SdkField<List<String>> TRIGGER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TriggerNames")
            .getter(getter(ListTriggersResponse::triggerNames))
            .setter(setter(Builder::triggerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTriggersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> triggerNames;

    private final String nextToken;

    private ListTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.triggerNames = builder.triggerNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TriggerNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTriggerNames() {
        return triggerNames != null && !(triggerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of all triggers in the account, or the triggers with the specified tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggerNames} method.
     * </p>
     * 
     * @return The names of all triggers in the account, or the triggers with the specified tags.
     */
    public final List<String> triggerNames() {
        return triggerNames;
    }

    /**
     * <p>
     * A continuation token, if the returned list does not contain the last metric available.
     * </p>
     * 
     * @return A continuation token, if the returned list does not contain the last metric available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggerNames() ? triggerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTriggersResponse)) {
            return false;
        }
        ListTriggersResponse other = (ListTriggersResponse) obj;
        return hasTriggerNames() == other.hasTriggerNames() && Objects.equals(triggerNames(), other.triggerNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTriggersResponse").add("TriggerNames", hasTriggerNames() ? triggerNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TriggerNames":
            return Optional.ofNullable(clazz.cast(triggerNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTriggersResponse, T> g) {
        return obj -> g.apply((ListTriggersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTriggersResponse> {
        /**
         * <p>
         * The names of all triggers in the account, or the triggers with the specified tags.
         * </p>
         * 
         * @param triggerNames
         *        The names of all triggers in the account, or the triggers with the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerNames(Collection<String> triggerNames);

        /**
         * <p>
         * The names of all triggers in the account, or the triggers with the specified tags.
         * </p>
         * 
         * @param triggerNames
         *        The names of all triggers in the account, or the triggers with the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerNames(String... triggerNames);

        /**
         * <p>
         * A continuation token, if the returned list does not contain the last metric available.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the returned list does not contain the last metric available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<String> triggerNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTriggersResponse model) {
            super(model);
            triggerNames(model.triggerNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTriggerNames() {
            if (triggerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return triggerNames;
        }

        public final void setTriggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
        }

        @Override
        @Transient
        public final Builder triggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggerNames(String... triggerNames) {
            triggerNames(Arrays.asList(triggerNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTriggersResponse build() {
            return new ListTriggersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
