/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption-at-rest settings of the transform that apply to accessing user data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MLUserDataEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<MLUserDataEncryption.Builder, MLUserDataEncryption> {
    private static final SdkField<String> ML_USER_DATA_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MlUserDataEncryptionMode").getter(getter(MLUserDataEncryption::mlUserDataEncryptionModeAsString))
            .setter(setter(Builder::mlUserDataEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlUserDataEncryptionMode").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(MLUserDataEncryption::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ML_USER_DATA_ENCRYPTION_MODE_FIELD, KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mlUserDataEncryptionMode;

    private final String kmsKeyId;

    private MLUserDataEncryption(BuilderImpl builder) {
        this.mlUserDataEncryptionMode = builder.mlUserDataEncryptionMode;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The encryption mode applied to user data. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISABLED: encryption is disabled
     * </p>
     * </li>
     * <li>
     * <p>
     * SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mlUserDataEncryptionMode} will return {@link MLUserDataEncryptionModeString#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #mlUserDataEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode applied to user data. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISABLED: encryption is disabled
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in
     *         Amazon S3.
     *         </p>
     *         </li>
     * @see MLUserDataEncryptionModeString
     */
    public final MLUserDataEncryptionModeString mlUserDataEncryptionMode() {
        return MLUserDataEncryptionModeString.fromValue(mlUserDataEncryptionMode);
    }

    /**
     * <p>
     * The encryption mode applied to user data. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISABLED: encryption is disabled
     * </p>
     * </li>
     * <li>
     * <p>
     * SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mlUserDataEncryptionMode} will return {@link MLUserDataEncryptionModeString#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #mlUserDataEncryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode applied to user data. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISABLED: encryption is disabled
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in
     *         Amazon S3.
     *         </p>
     *         </li>
     * @see MLUserDataEncryptionModeString
     */
    public final String mlUserDataEncryptionModeAsString() {
        return mlUserDataEncryptionMode;
    }

    /**
     * <p>
     * The ID for the customer-provided KMS key.
     * </p>
     * 
     * @return The ID for the customer-provided KMS key.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlUserDataEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLUserDataEncryption)) {
            return false;
        }
        MLUserDataEncryption other = (MLUserDataEncryption) obj;
        return Objects.equals(mlUserDataEncryptionModeAsString(), other.mlUserDataEncryptionModeAsString())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MLUserDataEncryption").add("MlUserDataEncryptionMode", mlUserDataEncryptionModeAsString())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MlUserDataEncryptionMode":
            return Optional.ofNullable(clazz.cast(mlUserDataEncryptionModeAsString()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MLUserDataEncryption, T> g) {
        return obj -> g.apply((MLUserDataEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MLUserDataEncryption> {
        /**
         * <p>
         * The encryption mode applied to user data. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISABLED: encryption is disabled
         * </p>
         * </li>
         * <li>
         * <p>
         * SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in Amazon
         * S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mlUserDataEncryptionMode
         *        The encryption mode applied to user data. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISABLED: encryption is disabled
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in
         *        Amazon S3.
         *        </p>
         *        </li>
         * @see MLUserDataEncryptionModeString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLUserDataEncryptionModeString
         */
        Builder mlUserDataEncryptionMode(String mlUserDataEncryptionMode);

        /**
         * <p>
         * The encryption mode applied to user data. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISABLED: encryption is disabled
         * </p>
         * </li>
         * <li>
         * <p>
         * SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in Amazon
         * S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mlUserDataEncryptionMode
         *        The encryption mode applied to user data. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISABLED: encryption is disabled
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in
         *        Amazon S3.
         *        </p>
         *        </li>
         * @see MLUserDataEncryptionModeString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLUserDataEncryptionModeString
         */
        Builder mlUserDataEncryptionMode(MLUserDataEncryptionModeString mlUserDataEncryptionMode);

        /**
         * <p>
         * The ID for the customer-provided KMS key.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID for the customer-provided KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String mlUserDataEncryptionMode;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MLUserDataEncryption model) {
            mlUserDataEncryptionMode(model.mlUserDataEncryptionMode);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getMlUserDataEncryptionMode() {
            return mlUserDataEncryptionMode;
        }

        public final void setMlUserDataEncryptionMode(String mlUserDataEncryptionMode) {
            this.mlUserDataEncryptionMode = mlUserDataEncryptionMode;
        }

        @Override
        @Transient
        public final Builder mlUserDataEncryptionMode(String mlUserDataEncryptionMode) {
            this.mlUserDataEncryptionMode = mlUserDataEncryptionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder mlUserDataEncryptionMode(MLUserDataEncryptionModeString mlUserDataEncryptionMode) {
            this.mlUserDataEncryptionMode(mlUserDataEncryptionMode == null ? null : mlUserDataEncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public MLUserDataEncryption build() {
            return new MLUserDataEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
