/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for a partition index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartitionIndex implements SdkPojo, Serializable, ToCopyableBuilder<PartitionIndex.Builder, PartitionIndex> {
    private static final SdkField<List<String>> KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(PartitionIndex::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(PartitionIndex::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYS_FIELD, INDEX_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> keys;

    private final String indexName;

    private PartitionIndex(BuilderImpl builder) {
        this.keys = builder.keys;
        this.indexName = builder.indexName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The keys for the partition index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return The keys for the partition index.
     */
    public final List<String> keys() {
        return keys;
    }

    /**
     * <p>
     * The name of the partition index.
     * </p>
     * 
     * @return The name of the partition index.
     */
    public final String indexName() {
        return indexName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionIndex)) {
            return false;
        }
        PartitionIndex other = (PartitionIndex) obj;
        return hasKeys() == other.hasKeys() && Objects.equals(keys(), other.keys())
                && Objects.equals(indexName(), other.indexName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartitionIndex").add("Keys", hasKeys() ? keys() : null).add("IndexName", indexName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionIndex, T> g) {
        return obj -> g.apply((PartitionIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartitionIndex> {
        /**
         * <p>
         * The keys for the partition index.
         * </p>
         * 
         * @param keys
         *        The keys for the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<String> keys);

        /**
         * <p>
         * The keys for the partition index.
         * </p>
         * 
         * @param keys
         *        The keys for the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(String... keys);

        /**
         * <p>
         * The name of the partition index.
         * </p>
         * 
         * @param indexName
         *        The name of the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private String indexName;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionIndex model) {
            keys(model.keys);
            indexName(model.indexName);
        }

        public final Collection<String> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = KeyListCopier.copy(keys);
        }

        @Override
        @Transient
        public final Builder keys(Collection<String> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keys(String... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        @Transient
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Override
        public PartitionIndex build() {
            return new PartitionIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
