/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The batch condition that started the workflow run. Either the number of events in the batch size arrived, in which
 * case the BatchSize member is non-zero, or the batch window expired, in which case the BatchWindow member is non-zero.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartingEventBatchCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<StartingEventBatchCondition.Builder, StartingEventBatchCondition> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(StartingEventBatchCondition::batchSize)).setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<Integer> BATCH_WINDOW_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchWindow").getter(getter(StartingEventBatchCondition::batchWindow))
            .setter(setter(Builder::batchWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchWindow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD,
            BATCH_WINDOW_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer batchSize;

    private final Integer batchWindow;

    private StartingEventBatchCondition(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.batchWindow = builder.batchWindow;
    }

    /**
     * <p>
     * Number of events in the batch.
     * </p>
     * 
     * @return Number of events in the batch.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * Duration of the batch window in seconds.
     * </p>
     * 
     * @return Duration of the batch window in seconds.
     */
    public final Integer batchWindow() {
        return batchWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(batchWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartingEventBatchCondition)) {
            return false;
        }
        StartingEventBatchCondition other = (StartingEventBatchCondition) obj;
        return Objects.equals(batchSize(), other.batchSize()) && Objects.equals(batchWindow(), other.batchWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartingEventBatchCondition").add("BatchSize", batchSize()).add("BatchWindow", batchWindow())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "BatchWindow":
            return Optional.ofNullable(clazz.cast(batchWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartingEventBatchCondition, T> g) {
        return obj -> g.apply((StartingEventBatchCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartingEventBatchCondition> {
        /**
         * <p>
         * Number of events in the batch.
         * </p>
         * 
         * @param batchSize
         *        Number of events in the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * Duration of the batch window in seconds.
         * </p>
         * 
         * @param batchWindow
         *        Duration of the batch window in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchWindow(Integer batchWindow);
    }

    static final class BuilderImpl implements Builder {
        private Integer batchSize;

        private Integer batchWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(StartingEventBatchCondition model) {
            batchSize(model.batchSize);
            batchWindow(model.batchWindow);
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        @Transient
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getBatchWindow() {
            return batchWindow;
        }

        public final void setBatchWindow(Integer batchWindow) {
            this.batchWindow = batchWindow;
        }

        @Override
        @Transient
        public final Builder batchWindow(Integer batchWindow) {
            this.batchWindow = batchWindow;
            return this;
        }

        @Override
        public StartingEventBatchCondition build() {
            return new StartingEventBatchCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
