/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A federation source failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FederationSourceException extends GlueException implements
        ToCopyableBuilder<FederationSourceException.Builder, FederationSourceException> {
    private static final SdkField<String> FEDERATION_SOURCE_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FederationSourceErrorCode").getter(getter(FederationSourceException::federationSourceErrorCodeAsString))
            .setter(setter(Builder::federationSourceErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationSourceErrorCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FEDERATION_SOURCE_ERROR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String federationSourceErrorCode;

    private FederationSourceException(BuilderImpl builder) {
        super(builder);
        this.federationSourceErrorCode = builder.federationSourceErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The error code of the problem.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #federationSourceErrorCode} will return {@link FederationSourceErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #federationSourceErrorCodeAsString}.
     * </p>
     * 
     * @return The error code of the problem.
     * @see FederationSourceErrorCode
     */
    public FederationSourceErrorCode federationSourceErrorCode() {
        return FederationSourceErrorCode.fromValue(federationSourceErrorCode);
    }

    /**
     * <p>
     * The error code of the problem.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #federationSourceErrorCode} will return {@link FederationSourceErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #federationSourceErrorCodeAsString}.
     * </p>
     * 
     * @return The error code of the problem.
     * @see FederationSourceErrorCode
     */
    public String federationSourceErrorCodeAsString() {
        return federationSourceErrorCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FederationSourceException, T> g) {
        return obj -> g.apply((FederationSourceException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FederationSourceException>, GlueException.Builder {
        /**
         * <p>
         * The error code of the problem.
         * </p>
         * 
         * @param federationSourceErrorCode
         *        The error code of the problem.
         * @see FederationSourceErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationSourceErrorCode
         */
        Builder federationSourceErrorCode(String federationSourceErrorCode);

        /**
         * <p>
         * The error code of the problem.
         * </p>
         * 
         * @param federationSourceErrorCode
         *        The error code of the problem.
         * @see FederationSourceErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationSourceErrorCode
         */
        Builder federationSourceErrorCode(FederationSourceErrorCode federationSourceErrorCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends GlueException.BuilderImpl implements Builder {
        private String federationSourceErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(FederationSourceException model) {
            super(model);
            federationSourceErrorCode(model.federationSourceErrorCode);
        }

        public final String getFederationSourceErrorCode() {
            return federationSourceErrorCode;
        }

        public final void setFederationSourceErrorCode(String federationSourceErrorCode) {
            this.federationSourceErrorCode = federationSourceErrorCode;
        }

        @Override
        public final Builder federationSourceErrorCode(String federationSourceErrorCode) {
            this.federationSourceErrorCode = federationSourceErrorCode;
            return this;
        }

        @Override
        public final Builder federationSourceErrorCode(FederationSourceErrorCode federationSourceErrorCode) {
            this.federationSourceErrorCode(federationSourceErrorCode == null ? null : federationSourceErrorCode.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public FederationSourceException build() {
            return new FederationSourceException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
