/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClassifierResponse extends GlueResponse implements
        ToCopyableBuilder<GetClassifierResponse.Builder, GetClassifierResponse> {
    private static final SdkField<Classifier> CLASSIFIER_FIELD = SdkField.<Classifier> builder(MarshallingType.SDK_POJO)
            .memberName("Classifier").getter(getter(GetClassifierResponse::classifier)).setter(setter(Builder::classifier))
            .constructor(Classifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFIER_FIELD));

    private final Classifier classifier;

    private GetClassifierResponse(BuilderImpl builder) {
        super(builder);
        this.classifier = builder.classifier;
    }

    /**
     * <p>
     * The requested classifier.
     * </p>
     * 
     * @return The requested classifier.
     */
    public final Classifier classifier() {
        return classifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(classifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClassifierResponse)) {
            return false;
        }
        GetClassifierResponse other = (GetClassifierResponse) obj;
        return Objects.equals(classifier(), other.classifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClassifierResponse").add("Classifier", classifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Classifier":
            return Optional.ofNullable(clazz.cast(classifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClassifierResponse, T> g) {
        return obj -> g.apply((GetClassifierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetClassifierResponse> {
        /**
         * <p>
         * The requested classifier.
         * </p>
         * 
         * @param classifier
         *        The requested classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifier(Classifier classifier);

        /**
         * <p>
         * The requested classifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link Classifier.Builder} avoiding the need to
         * create one manually via {@link Classifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Classifier.Builder#build()} is called immediately and its result
         * is passed to {@link #classifier(Classifier)}.
         * 
         * @param classifier
         *        a consumer that will call methods on {@link Classifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classifier(Classifier)
         */
        default Builder classifier(Consumer<Classifier.Builder> classifier) {
            return classifier(Classifier.builder().applyMutation(classifier).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Classifier classifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClassifierResponse model) {
            super(model);
            classifier(model.classifier);
        }

        public final Classifier.Builder getClassifier() {
            return classifier != null ? classifier.toBuilder() : null;
        }

        public final void setClassifier(Classifier.BuilderImpl classifier) {
            this.classifier = classifier != null ? classifier.build() : null;
        }

        @Override
        public final Builder classifier(Classifier classifier) {
            this.classifier = classifier;
            return this;
        }

        @Override
        public GetClassifierResponse build() {
            return new GetClassifierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
