/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a target that writes to a Delta Lake data source in the Glue Data Catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DeltaCatalogTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DeltaCatalogTarget.Builder, S3DeltaCatalogTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(S3DeltaCatalogTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(S3DeltaCatalogTarget::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<String>>> PARTITION_KEYS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("PartitionKeys")
            .getter(getter(S3DeltaCatalogTarget::partitionKeys))
            .setter(setter(Builder::partitionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(S3DeltaCatalogTarget::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(S3DeltaCatalogTarget::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalOptions")
            .getter(getter(S3DeltaCatalogTarget::additionalOptions))
            .setter(setter(Builder::additionalOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<CatalogSchemaChangePolicy> SCHEMA_CHANGE_POLICY_FIELD = SdkField
            .<CatalogSchemaChangePolicy> builder(MarshallingType.SDK_POJO).memberName("SchemaChangePolicy")
            .getter(getter(S3DeltaCatalogTarget::schemaChangePolicy)).setter(setter(Builder::schemaChangePolicy))
            .constructor(CatalogSchemaChangePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            PARTITION_KEYS_FIELD, TABLE_FIELD, DATABASE_FIELD, ADDITIONAL_OPTIONS_FIELD, SCHEMA_CHANGE_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final List<List<String>> partitionKeys;

    private final String table;

    private final String database;

    private final Map<String, String> additionalOptions;

    private final CatalogSchemaChangePolicy schemaChangePolicy;

    private S3DeltaCatalogTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.partitionKeys = builder.partitionKeys;
        this.table = builder.table;
        this.database = builder.database;
        this.additionalOptions = builder.additionalOptions;
        this.schemaChangePolicy = builder.schemaChangePolicy;
    }

    /**
     * <p>
     * The name of the data target.
     * </p>
     * 
     * @return The name of the data target.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes that are inputs to the data target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The nodes that are inputs to the data target.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionKeys() {
        return partitionKeys != null && !(partitionKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies native partitioning using a sequence of keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionKeys} method.
     * </p>
     * 
     * @return Specifies native partitioning using a sequence of keys.
     */
    public final List<List<String>> partitionKeys() {
        return partitionKeys;
    }

    /**
     * <p>
     * The name of the table in the database to write to.
     * </p>
     * 
     * @return The name of the table in the database to write to.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * The name of the database to write to.
     * </p>
     * 
     * @return The name of the database to write to.
     */
    public final String database() {
        return database;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalOptions() {
        return additionalOptions != null && !(additionalOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies additional connection options for the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalOptions} method.
     * </p>
     * 
     * @return Specifies additional connection options for the connector.
     */
    public final Map<String, String> additionalOptions() {
        return additionalOptions;
    }

    /**
     * <p>
     * A policy that specifies update behavior for the crawler.
     * </p>
     * 
     * @return A policy that specifies update behavior for the crawler.
     */
    public final CatalogSchemaChangePolicy schemaChangePolicy() {
        return schemaChangePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionKeys() ? partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalOptions() ? additionalOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaChangePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DeltaCatalogTarget)) {
            return false;
        }
        S3DeltaCatalogTarget other = (S3DeltaCatalogTarget) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasPartitionKeys() == other.hasPartitionKeys()
                && Objects.equals(partitionKeys(), other.partitionKeys()) && Objects.equals(table(), other.table())
                && Objects.equals(database(), other.database()) && hasAdditionalOptions() == other.hasAdditionalOptions()
                && Objects.equals(additionalOptions(), other.additionalOptions())
                && Objects.equals(schemaChangePolicy(), other.schemaChangePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DeltaCatalogTarget").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("PartitionKeys", hasPartitionKeys() ? partitionKeys() : null).add("Table", table())
                .add("Database", database()).add("AdditionalOptions", hasAdditionalOptions() ? additionalOptions() : null)
                .add("SchemaChangePolicy", schemaChangePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "PartitionKeys":
            return Optional.ofNullable(clazz.cast(partitionKeys()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "AdditionalOptions":
            return Optional.ofNullable(clazz.cast(additionalOptions()));
        case "SchemaChangePolicy":
            return Optional.ofNullable(clazz.cast(schemaChangePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DeltaCatalogTarget, T> g) {
        return obj -> g.apply((S3DeltaCatalogTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DeltaCatalogTarget> {
        /**
         * <p>
         * The name of the data target.
         * </p>
         * 
         * @param name
         *        The name of the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * Specifies native partitioning using a sequence of keys.
         * </p>
         * 
         * @param partitionKeys
         *        Specifies native partitioning using a sequence of keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys);

        /**
         * <p>
         * Specifies native partitioning using a sequence of keys.
         * </p>
         * 
         * @param partitionKeys
         *        Specifies native partitioning using a sequence of keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<String>... partitionKeys);

        /**
         * <p>
         * The name of the table in the database to write to.
         * </p>
         * 
         * @param table
         *        The name of the table in the database to write to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * The name of the database to write to.
         * </p>
         * 
         * @param database
         *        The name of the database to write to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * Specifies additional connection options for the connector.
         * </p>
         * 
         * @param additionalOptions
         *        Specifies additional connection options for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalOptions(Map<String, String> additionalOptions);

        /**
         * <p>
         * A policy that specifies update behavior for the crawler.
         * </p>
         * 
         * @param schemaChangePolicy
         *        A policy that specifies update behavior for the crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaChangePolicy(CatalogSchemaChangePolicy schemaChangePolicy);

        /**
         * <p>
         * A policy that specifies update behavior for the crawler.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogSchemaChangePolicy.Builder}
         * avoiding the need to create one manually via {@link CatalogSchemaChangePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogSchemaChangePolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaChangePolicy(CatalogSchemaChangePolicy)}.
         * 
         * @param schemaChangePolicy
         *        a consumer that will call methods on {@link CatalogSchemaChangePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaChangePolicy(CatalogSchemaChangePolicy)
         */
        default Builder schemaChangePolicy(Consumer<CatalogSchemaChangePolicy.Builder> schemaChangePolicy) {
            return schemaChangePolicy(CatalogSchemaChangePolicy.builder().applyMutation(schemaChangePolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<List<String>> partitionKeys = DefaultSdkAutoConstructList.getInstance();

        private String table;

        private String database;

        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();

        private CatalogSchemaChangePolicy schemaChangePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DeltaCatalogTarget model) {
            name(model.name);
            inputs(model.inputs);
            partitionKeys(model.partitionKeys);
            table(model.table);
            database(model.database);
            additionalOptions(model.additionalOptions);
            schemaChangePolicy(model.schemaChangePolicy);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<? extends Collection<String>> getPartitionKeys() {
            if (partitionKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionKeys;
        }

        public final void setPartitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<? extends Collection<String>> partitionKeys) {
            this.partitionKeys = GlueStudioPathListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Collection<String>... partitionKeys) {
            partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        public final CatalogSchemaChangePolicy.Builder getSchemaChangePolicy() {
            return schemaChangePolicy != null ? schemaChangePolicy.toBuilder() : null;
        }

        public final void setSchemaChangePolicy(CatalogSchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        @Override
        public final Builder schemaChangePolicy(CatalogSchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        @Override
        public S3DeltaCatalogTarget build() {
            return new S3DeltaCatalogTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
