/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.EncryptionAtRest;
import software.amazon.awssdk.services.kafka.model.EncryptionInTransit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionInfo> {
    private static final SdkField<EncryptionAtRest> ENCRYPTION_AT_REST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRest").getter(EncryptionInfo.getter(EncryptionInfo::encryptionAtRest)).setter(EncryptionInfo.setter(Builder::encryptionAtRest)).constructor(EncryptionAtRest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionAtRest").build()}).build();
    private static final SdkField<EncryptionInTransit> ENCRYPTION_IN_TRANSIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionInTransit").getter(EncryptionInfo.getter(EncryptionInfo::encryptionInTransit)).setter(EncryptionInfo.setter(Builder::encryptionInTransit)).constructor(EncryptionInTransit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInTransit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_AT_REST_FIELD, ENCRYPTION_IN_TRANSIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EncryptionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EncryptionAtRest encryptionAtRest;
    private final EncryptionInTransit encryptionInTransit;

    private EncryptionInfo(BuilderImpl builder) {
        this.encryptionAtRest = builder.encryptionAtRest;
        this.encryptionInTransit = builder.encryptionInTransit;
    }

    public final EncryptionAtRest encryptionAtRest() {
        return this.encryptionAtRest;
    }

    public final EncryptionInTransit encryptionInTransit() {
        return this.encryptionInTransit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRest());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInTransit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionInfo)) {
            return false;
        }
        EncryptionInfo other = (EncryptionInfo)obj;
        return Objects.equals(this.encryptionAtRest(), other.encryptionAtRest()) && Objects.equals(this.encryptionInTransit(), other.encryptionInTransit());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionInfo").add("EncryptionAtRest", (Object)this.encryptionAtRest()).add("EncryptionInTransit", (Object)this.encryptionInTransit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionAtRest": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRest()));
            }
            case "EncryptionInTransit": {
                return Optional.ofNullable(clazz.cast(this.encryptionInTransit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encryptionAtRest", ENCRYPTION_AT_REST_FIELD);
        map.put("encryptionInTransit", ENCRYPTION_IN_TRANSIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionInfo, T> g) {
        return obj -> g.apply((EncryptionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EncryptionAtRest encryptionAtRest;
        private EncryptionInTransit encryptionInTransit;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionInfo model) {
            this.encryptionAtRest(model.encryptionAtRest);
            this.encryptionInTransit(model.encryptionInTransit);
        }

        public final EncryptionAtRest.Builder getEncryptionAtRest() {
            return this.encryptionAtRest != null ? this.encryptionAtRest.toBuilder() : null;
        }

        public final void setEncryptionAtRest(EncryptionAtRest.BuilderImpl encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest != null ? encryptionAtRest.build() : null;
        }

        @Override
        public final Builder encryptionAtRest(EncryptionAtRest encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest;
            return this;
        }

        public final EncryptionInTransit.Builder getEncryptionInTransit() {
            return this.encryptionInTransit != null ? this.encryptionInTransit.toBuilder() : null;
        }

        public final void setEncryptionInTransit(EncryptionInTransit.BuilderImpl encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit != null ? encryptionInTransit.build() : null;
        }

        @Override
        public final Builder encryptionInTransit(EncryptionInTransit encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit;
            return this;
        }

        public EncryptionInfo build() {
            return new EncryptionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionInfo> {
        public Builder encryptionAtRest(EncryptionAtRest var1);

        default public Builder encryptionAtRest(Consumer<EncryptionAtRest.Builder> encryptionAtRest) {
            return this.encryptionAtRest((EncryptionAtRest)((EncryptionAtRest.Builder)EncryptionAtRest.builder().applyMutation(encryptionAtRest)).build());
        }

        public Builder encryptionInTransit(EncryptionInTransit var1);

        default public Builder encryptionInTransit(Consumer<EncryptionInTransit.Builder> encryptionInTransit) {
            return this.encryptionInTransit((EncryptionInTransit)((EncryptionInTransit.Builder)EncryptionInTransit.builder().applyMutation(encryptionInTransit)).build());
        }
    }
}

