/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ConsumerGroupReplication;
import software.amazon.awssdk.services.kafka.model.TargetCompressionType;
import software.amazon.awssdk.services.kafka.model.TopicReplication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationInfo> {
    private static final SdkField<ConsumerGroupReplication> CONSUMER_GROUP_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumerGroupReplication").getter(ReplicationInfo.getter(ReplicationInfo::consumerGroupReplication)).setter(ReplicationInfo.setter(Builder::consumerGroupReplication)).constructor(ConsumerGroupReplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupReplication").build()}).build();
    private static final SdkField<String> SOURCE_KAFKA_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceKafkaClusterArn").getter(ReplicationInfo.getter(ReplicationInfo::sourceKafkaClusterArn)).setter(ReplicationInfo.setter(Builder::sourceKafkaClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKafkaClusterArn").build()}).build();
    private static final SdkField<String> TARGET_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCompressionType").getter(ReplicationInfo.getter(ReplicationInfo::targetCompressionTypeAsString)).setter(ReplicationInfo.setter(Builder::targetCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCompressionType").build()}).build();
    private static final SdkField<String> TARGET_KAFKA_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetKafkaClusterArn").getter(ReplicationInfo.getter(ReplicationInfo::targetKafkaClusterArn)).setter(ReplicationInfo.setter(Builder::targetKafkaClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKafkaClusterArn").build()}).build();
    private static final SdkField<TopicReplication> TOPIC_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopicReplication").getter(ReplicationInfo.getter(ReplicationInfo::topicReplication)).setter(ReplicationInfo.setter(Builder::topicReplication)).constructor(TopicReplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicReplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_GROUP_REPLICATION_FIELD, SOURCE_KAFKA_CLUSTER_ARN_FIELD, TARGET_COMPRESSION_TYPE_FIELD, TARGET_KAFKA_CLUSTER_ARN_FIELD, TOPIC_REPLICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicationInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConsumerGroupReplication consumerGroupReplication;
    private final String sourceKafkaClusterArn;
    private final String targetCompressionType;
    private final String targetKafkaClusterArn;
    private final TopicReplication topicReplication;

    private ReplicationInfo(BuilderImpl builder) {
        this.consumerGroupReplication = builder.consumerGroupReplication;
        this.sourceKafkaClusterArn = builder.sourceKafkaClusterArn;
        this.targetCompressionType = builder.targetCompressionType;
        this.targetKafkaClusterArn = builder.targetKafkaClusterArn;
        this.topicReplication = builder.topicReplication;
    }

    public final ConsumerGroupReplication consumerGroupReplication() {
        return this.consumerGroupReplication;
    }

    public final String sourceKafkaClusterArn() {
        return this.sourceKafkaClusterArn;
    }

    public final TargetCompressionType targetCompressionType() {
        return TargetCompressionType.fromValue(this.targetCompressionType);
    }

    public final String targetCompressionTypeAsString() {
        return this.targetCompressionType;
    }

    public final String targetKafkaClusterArn() {
        return this.targetKafkaClusterArn;
    }

    public final TopicReplication topicReplication() {
        return this.topicReplication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerGroupReplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicReplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInfo)) {
            return false;
        }
        ReplicationInfo other = (ReplicationInfo)obj;
        return Objects.equals(this.consumerGroupReplication(), other.consumerGroupReplication()) && Objects.equals(this.sourceKafkaClusterArn(), other.sourceKafkaClusterArn()) && Objects.equals(this.targetCompressionTypeAsString(), other.targetCompressionTypeAsString()) && Objects.equals(this.targetKafkaClusterArn(), other.targetKafkaClusterArn()) && Objects.equals(this.topicReplication(), other.topicReplication());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationInfo").add("ConsumerGroupReplication", (Object)this.consumerGroupReplication()).add("SourceKafkaClusterArn", (Object)this.sourceKafkaClusterArn()).add("TargetCompressionType", (Object)this.targetCompressionTypeAsString()).add("TargetKafkaClusterArn", (Object)this.targetKafkaClusterArn()).add("TopicReplication", (Object)this.topicReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerGroupReplication": {
                return Optional.ofNullable(clazz.cast(this.consumerGroupReplication()));
            }
            case "SourceKafkaClusterArn": {
                return Optional.ofNullable(clazz.cast(this.sourceKafkaClusterArn()));
            }
            case "TargetCompressionType": {
                return Optional.ofNullable(clazz.cast(this.targetCompressionTypeAsString()));
            }
            case "TargetKafkaClusterArn": {
                return Optional.ofNullable(clazz.cast(this.targetKafkaClusterArn()));
            }
            case "TopicReplication": {
                return Optional.ofNullable(clazz.cast(this.topicReplication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consumerGroupReplication", CONSUMER_GROUP_REPLICATION_FIELD);
        map.put("sourceKafkaClusterArn", SOURCE_KAFKA_CLUSTER_ARN_FIELD);
        map.put("targetCompressionType", TARGET_COMPRESSION_TYPE_FIELD);
        map.put("targetKafkaClusterArn", TARGET_KAFKA_CLUSTER_ARN_FIELD);
        map.put("topicReplication", TOPIC_REPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInfo, T> g) {
        return obj -> g.apply((ReplicationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConsumerGroupReplication consumerGroupReplication;
        private String sourceKafkaClusterArn;
        private String targetCompressionType;
        private String targetKafkaClusterArn;
        private TopicReplication topicReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInfo model) {
            this.consumerGroupReplication(model.consumerGroupReplication);
            this.sourceKafkaClusterArn(model.sourceKafkaClusterArn);
            this.targetCompressionType(model.targetCompressionType);
            this.targetKafkaClusterArn(model.targetKafkaClusterArn);
            this.topicReplication(model.topicReplication);
        }

        public final ConsumerGroupReplication.Builder getConsumerGroupReplication() {
            return this.consumerGroupReplication != null ? this.consumerGroupReplication.toBuilder() : null;
        }

        public final void setConsumerGroupReplication(ConsumerGroupReplication.BuilderImpl consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication != null ? consumerGroupReplication.build() : null;
        }

        @Override
        public final Builder consumerGroupReplication(ConsumerGroupReplication consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication;
            return this;
        }

        public final String getSourceKafkaClusterArn() {
            return this.sourceKafkaClusterArn;
        }

        public final void setSourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
        }

        @Override
        public final Builder sourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
            return this;
        }

        public final String getTargetCompressionType() {
            return this.targetCompressionType;
        }

        public final void setTargetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
        }

        @Override
        public final Builder targetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
            return this;
        }

        @Override
        public final Builder targetCompressionType(TargetCompressionType targetCompressionType) {
            this.targetCompressionType(targetCompressionType == null ? null : targetCompressionType.toString());
            return this;
        }

        public final String getTargetKafkaClusterArn() {
            return this.targetKafkaClusterArn;
        }

        public final void setTargetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
        }

        @Override
        public final Builder targetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
            return this;
        }

        public final TopicReplication.Builder getTopicReplication() {
            return this.topicReplication != null ? this.topicReplication.toBuilder() : null;
        }

        public final void setTopicReplication(TopicReplication.BuilderImpl topicReplication) {
            this.topicReplication = topicReplication != null ? topicReplication.build() : null;
        }

        @Override
        public final Builder topicReplication(TopicReplication topicReplication) {
            this.topicReplication = topicReplication;
            return this;
        }

        public ReplicationInfo build() {
            return new ReplicationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationInfo> {
        public Builder consumerGroupReplication(ConsumerGroupReplication var1);

        default public Builder consumerGroupReplication(Consumer<ConsumerGroupReplication.Builder> consumerGroupReplication) {
            return this.consumerGroupReplication((ConsumerGroupReplication)((ConsumerGroupReplication.Builder)ConsumerGroupReplication.builder().applyMutation(consumerGroupReplication)).build());
        }

        public Builder sourceKafkaClusterArn(String var1);

        public Builder targetCompressionType(String var1);

        public Builder targetCompressionType(TargetCompressionType var1);

        public Builder targetKafkaClusterArn(String var1);

        public Builder topicReplication(TopicReplication var1);

        default public Builder topicReplication(Consumer<TopicReplication.Builder> topicReplication) {
            return this.topicReplication((TopicReplication)((TopicReplication.Builder)TopicReplication.builder().applyMutation(topicReplication)).build());
        }
    }
}

