/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointParams;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointProvider;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultKinesisEndpointProvider
implements KinesisEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(KinesisEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(KinesisEndpointParams params, LocalState locals) {
        RuleResult result = DefaultKinesisEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule33(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule65(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule97(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule101(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultKinesisEndpointProvider.endpointRule117(params, locals);
    }

    private static RuleResult endpointRule1(KinesisEndpointParams params, LocalState locals) {
        if (params.streamArn() != null && params.endpoint() == null && locals.region() != null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition(locals.region());
            if (partitionResult != null && !"aws-iso".equals((locals = locals.toBuilder().partitionResult(partitionResult).build()).partitionResult().name()) && !"aws-iso-b".equals(locals.partitionResult().name())) {
                RuleResult result = DefaultKinesisEndpointProvider.endpointRule2(params, locals);
                if (result.isResolved()) {
                    return result;
                }
                return DefaultKinesisEndpointProvider.endpointRule32(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(KinesisEndpointParams params, LocalState locals) {
        RuleArn arn = null;
        arn = RulesFunctions.awsParseArn(params.streamArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule3(params, locals = locals.toBuilder().arn(arn).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule31(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.arn().accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule4(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule30(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.arn().region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule5(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule29(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(KinesisEndpointParams params, LocalState locals) {
        if ("kinesis".equals(locals.arn().service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule6(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule28(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(KinesisEndpointParams params, LocalState locals) {
        String arnType = null;
        arnType = RulesFunctions.listAccess(locals.arn().resourceId(), 0);
        if (arnType != null && !"".equals((locals = locals.toBuilder().arnType(arnType).build()).arnType())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule7(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule27(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(KinesisEndpointParams params, LocalState locals) {
        if ("stream".equals(locals.arnType())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule26(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.stringEquals(locals.partitionResult().name(), locals.arn().partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule25(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(KinesisEndpointParams params, LocalState locals) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule14(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule13(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule14(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
    }

    private static RuleResult endpointRule15(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
    }

    private static RuleResult endpointRule16(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule19(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultKinesisEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule19(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule20(KinesisEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule23(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule24(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule25(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
    }

    private static RuleResult endpointRule26(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Partition: " + locals.arn().partition() + " from ARN doesn't match with partition name: " + locals.partitionResult().name() + ".");
    }

    private static RuleResult endpointRule27(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + locals.arnType() + "` arn types.");
    }

    private static RuleResult endpointRule28(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: No ARN type specified");
    }

    private static RuleResult endpointRule29(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + locals.arn().service() + ".");
    }

    private static RuleResult endpointRule30(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Invalid region.");
    }

    private static RuleResult endpointRule31(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Invalid account id.");
    }

    private static RuleResult endpointRule32(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Failed to parse ARN.");
    }

    private static RuleResult endpointRule33(KinesisEndpointParams params, LocalState locals) {
        if (params.consumerArn() != null && params.endpoint() == null && locals.region() != null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition(locals.region());
            if (partitionResult != null && !"aws-iso".equals((locals = locals.toBuilder().partitionResult(partitionResult).build()).partitionResult().name()) && !"aws-iso-b".equals(locals.partitionResult().name())) {
                RuleResult result = DefaultKinesisEndpointProvider.endpointRule34(params, locals);
                if (result.isResolved()) {
                    return result;
                }
                return DefaultKinesisEndpointProvider.endpointRule64(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule34(KinesisEndpointParams params, LocalState locals) {
        RuleArn arn = null;
        arn = RulesFunctions.awsParseArn(params.consumerArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule35(params, locals = locals.toBuilder().arn(arn).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule63(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule35(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.arn().accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule36(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule62(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule36(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.arn().region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule37(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule61(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule37(KinesisEndpointParams params, LocalState locals) {
        if ("kinesis".equals(locals.arn().service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule38(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule60(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule38(KinesisEndpointParams params, LocalState locals) {
        String arnType = null;
        arnType = RulesFunctions.listAccess(locals.arn().resourceId(), 0);
        if (arnType != null && !"".equals((locals = locals.toBuilder().arnType(arnType).build()).arnType())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule39(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule59(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule39(KinesisEndpointParams params, LocalState locals) {
        if ("stream".equals(locals.arnType())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule40(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule58(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule40(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.stringEquals(locals.partitionResult().name(), locals.arn().partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule41(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule57(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule41(KinesisEndpointParams params, LocalState locals) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule42(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule48(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule52(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule56(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule42(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule43(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule47(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule43(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule44(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule46(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule44(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule45(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule45(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule46(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
    }

    private static RuleResult endpointRule47(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
    }

    private static RuleResult endpointRule48(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule49(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule51(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule49(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultKinesisEndpointProvider.endpointRule50(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule50(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule51(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule52(KinesisEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule53(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule55(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule53(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule54(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule54(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule55(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule56(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule57(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
    }

    private static RuleResult endpointRule58(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Partition: " + locals.arn().partition() + " from ARN doesn't match with partition name: " + locals.partitionResult().name() + ".");
    }

    private static RuleResult endpointRule59(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + locals.arnType() + "` arn types.");
    }

    private static RuleResult endpointRule60(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: No ARN type specified");
    }

    private static RuleResult endpointRule61(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + locals.arn().service() + ".");
    }

    private static RuleResult endpointRule62(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Invalid region.");
    }

    private static RuleResult endpointRule63(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Invalid account id.");
    }

    private static RuleResult endpointRule64(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Failed to parse ARN.");
    }

    private static RuleResult endpointRule65(KinesisEndpointParams params, LocalState locals) {
        if (params.resourceArn() != null && params.endpoint() == null && locals.region() != null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition(locals.region());
            if (partitionResult != null && !"aws-iso".equals((locals = locals.toBuilder().partitionResult(partitionResult).build()).partitionResult().name()) && !"aws-iso-b".equals(locals.partitionResult().name())) {
                RuleResult result = DefaultKinesisEndpointProvider.endpointRule66(params, locals);
                if (result.isResolved()) {
                    return result;
                }
                return DefaultKinesisEndpointProvider.endpointRule96(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule66(KinesisEndpointParams params, LocalState locals) {
        RuleArn arn = null;
        arn = RulesFunctions.awsParseArn(params.resourceArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule67(params, locals = locals.toBuilder().arn(arn).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule95(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule67(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.arn().accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule68(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule94(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule68(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(locals.arn().region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule69(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule93(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule69(KinesisEndpointParams params, LocalState locals) {
        if ("kinesis".equals(locals.arn().service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule70(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule92(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule70(KinesisEndpointParams params, LocalState locals) {
        String arnType = null;
        arnType = RulesFunctions.listAccess(locals.arn().resourceId(), 0);
        if (arnType != null && !"".equals((locals = locals.toBuilder().arnType(arnType).build()).arnType())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule71(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule91(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule71(KinesisEndpointParams params, LocalState locals) {
        if ("stream".equals(locals.arnType())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule72(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule90(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule72(KinesisEndpointParams params, LocalState locals) {
        if (RulesFunctions.stringEquals(locals.partitionResult().name(), locals.arn().partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule73(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule89(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule73(KinesisEndpointParams params, LocalState locals) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule74(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule80(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule84(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule88(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule74(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule75(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule79(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule75(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule76(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule78(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule76(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule77(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule77(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule78(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
    }

    private static RuleResult endpointRule79(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
    }

    private static RuleResult endpointRule80(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule81(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule83(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule81(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultKinesisEndpointProvider.endpointRule82(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule82(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule83(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule84(KinesisEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule85(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule87(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule85(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule86(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule86(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule87(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule88(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.arn().accountId() + "." + params.operationType() + "-kinesis." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule89(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
    }

    private static RuleResult endpointRule90(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Partition: " + locals.arn().partition() + " from ARN doesn't match with partition name: " + locals.partitionResult().name() + ".");
    }

    private static RuleResult endpointRule91(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + locals.arnType() + "` arn types.");
    }

    private static RuleResult endpointRule92(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: No ARN type specified");
    }

    private static RuleResult endpointRule93(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + locals.arn().service() + ".");
    }

    private static RuleResult endpointRule94(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Invalid region.");
    }

    private static RuleResult endpointRule95(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Invalid account id.");
    }

    private static RuleResult endpointRule96(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid ARN: Failed to parse ARN.");
    }

    private static RuleResult endpointRule97(KinesisEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule98(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule99(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule100(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule98(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule99(KinesisEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule100(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule101(KinesisEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultKinesisEndpointProvider.endpointRule102(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule102(KinesisEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule103(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule107(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule112(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule116(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule103(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule104(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule106(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule104(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule105(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule105(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule106(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule107(KinesisEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule108(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule111(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule108(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule109(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule110(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule109(KinesisEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule110(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule111(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule112(KinesisEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule113(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultKinesisEndpointProvider.endpointRule115(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule113(KinesisEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultKinesisEndpointProvider.endpointRule114(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule114(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule115(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule116(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule117(KinesisEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;
        private RuleArn arn;
        private String arnType;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
            this.arn = null;
            this.arnType = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
            this.arn = locals.arn;
            this.arnType = locals.arnType;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        public LocalStateBuilder arn(RuleArn value) {
            this.arn = value;
            return this;
        }

        public LocalStateBuilder arnType(String value) {
            this.arnType = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;
        private final RuleArn arn;
        private final String arnType;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
            this.arn = null;
            this.arnType = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
            this.arn = null;
            this.arnType = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
            this.arn = builder.arn;
            this.arnType = builder.arnType;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public RuleArn arn() {
            return this.arn;
        }

        public String arnType() {
            return this.arnType;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

