/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping between an Amazon Web Services resource and a Lambda function. For details, see
 * <a>CreateEventSourceMapping</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEventSourceMappingResponse extends LambdaResponse implements
        ToCopyableBuilder<DeleteEventSourceMappingResponse.Builder, DeleteEventSourceMappingResponse> {
    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UUID")
            .getter(getter(DeleteEventSourceMappingResponse::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()).build();

    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingPosition").getter(getter(DeleteEventSourceMappingResponse::startingPositionAsString))
            .setter(setter(Builder::startingPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()).build();

    private static final SdkField<Instant> STARTING_POSITION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("StartingPositionTimestamp")
            .getter(getter(DeleteEventSourceMappingResponse::startingPositionTimestamp))
            .setter(setter(Builder::startingPositionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPositionTimestamp").build())
            .build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(DeleteEventSourceMappingResponse::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(DeleteEventSourceMappingResponse::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelizationFactor").getter(getter(DeleteEventSourceMappingResponse::parallelizationFactor))
            .setter(setter(Builder::parallelizationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build())
            .build();

    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceArn").getter(getter(DeleteEventSourceMappingResponse::eventSourceArn))
            .setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<FilterCriteria> builder(MarshallingType.SDK_POJO).memberName("FilterCriteria")
            .getter(getter(DeleteEventSourceMappingResponse::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(FilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(DeleteEventSourceMappingResponse::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(DeleteEventSourceMappingResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> LAST_PROCESSING_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastProcessingResult").getter(getter(DeleteEventSourceMappingResponse::lastProcessingResult))
            .setter(setter(Builder::lastProcessingResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProcessingResult").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DeleteEventSourceMappingResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateTransitionReason").getter(getter(DeleteEventSourceMappingResponse::stateTransitionReason))
            .setter(setter(Builder::stateTransitionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").build())
            .build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("DestinationConfig")
            .getter(getter(DeleteEventSourceMappingResponse::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()).build();

    private static final SdkField<List<String>> TOPICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Topics")
            .getter(getter(DeleteEventSourceMappingResponse::topics))
            .setter(setter(Builder::topics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> QUEUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Queues")
            .getter(getter(DeleteEventSourceMappingResponse::queues))
            .setter(setter(Builder::queues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SourceAccessConfiguration>> SOURCE_ACCESS_CONFIGURATIONS_FIELD = SdkField
            .<List<SourceAccessConfiguration>> builder(MarshallingType.LIST)
            .memberName("SourceAccessConfigurations")
            .getter(getter(DeleteEventSourceMappingResponse::sourceAccessConfigurations))
            .setter(setter(Builder::sourceAccessConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccessConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceAccessConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceAccessConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SelfManagedEventSource> SELF_MANAGED_EVENT_SOURCE_FIELD = SdkField
            .<SelfManagedEventSource> builder(MarshallingType.SDK_POJO).memberName("SelfManagedEventSource")
            .getter(getter(DeleteEventSourceMappingResponse::selfManagedEventSource))
            .setter(setter(Builder::selfManagedEventSource)).constructor(SelfManagedEventSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedEventSource").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds")
            .getter(getter(DeleteEventSourceMappingResponse::maximumRecordAgeInSeconds))
            .setter(setter(Builder::maximumRecordAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build())
            .build();

    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BisectBatchOnFunctionError")
            .getter(getter(DeleteEventSourceMappingResponse::bisectBatchOnFunctionError))
            .setter(setter(Builder::bisectBatchOnFunctionError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(DeleteEventSourceMappingResponse::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final SdkField<Integer> TUMBLING_WINDOW_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TumblingWindowInSeconds").getter(getter(DeleteEventSourceMappingResponse::tumblingWindowInSeconds))
            .setter(setter(Builder::tumblingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TumblingWindowInSeconds").build())
            .build();

    private static final SdkField<List<String>> FUNCTION_RESPONSE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FunctionResponseTypes")
            .getter(getter(DeleteEventSourceMappingResponse::functionResponseTypesAsStrings))
            .setter(setter(Builder::functionResponseTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionResponseTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AmazonManagedKafkaEventSourceConfig> AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField
            .<AmazonManagedKafkaEventSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonManagedKafkaEventSourceConfig")
            .getter(getter(DeleteEventSourceMappingResponse::amazonManagedKafkaEventSourceConfig))
            .setter(setter(Builder::amazonManagedKafkaEventSourceConfig))
            .constructor(AmazonManagedKafkaEventSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AmazonManagedKafkaEventSourceConfig").build()).build();

    private static final SdkField<SelfManagedKafkaEventSourceConfig> SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField
            .<SelfManagedKafkaEventSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedKafkaEventSourceConfig")
            .getter(getter(DeleteEventSourceMappingResponse::selfManagedKafkaEventSourceConfig))
            .setter(setter(Builder::selfManagedKafkaEventSourceConfig))
            .constructor(SelfManagedKafkaEventSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaEventSourceConfig")
                    .build()).build();

    private static final SdkField<ScalingConfig> SCALING_CONFIG_FIELD = SdkField
            .<ScalingConfig> builder(MarshallingType.SDK_POJO).memberName("ScalingConfig")
            .getter(getter(DeleteEventSourceMappingResponse::scalingConfig)).setter(setter(Builder::scalingConfig))
            .constructor(ScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfig").build()).build();

    private static final SdkField<DocumentDBEventSourceConfig> DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD = SdkField
            .<DocumentDBEventSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DocumentDBEventSourceConfig")
            .getter(getter(DeleteEventSourceMappingResponse::documentDBEventSourceConfig))
            .setter(setter(Builder::documentDBEventSourceConfig))
            .constructor(DocumentDBEventSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDBEventSourceConfig")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyArn").getter(getter(DeleteEventSourceMappingResponse::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()).build();

    private static final SdkField<FilterCriteriaError> FILTER_CRITERIA_ERROR_FIELD = SdkField
            .<FilterCriteriaError> builder(MarshallingType.SDK_POJO).memberName("FilterCriteriaError")
            .getter(getter(DeleteEventSourceMappingResponse::filterCriteriaError)).setter(setter(Builder::filterCriteriaError))
            .constructor(FilterCriteriaError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteriaError").build())
            .build();

    private static final SdkField<String> EVENT_SOURCE_MAPPING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceMappingArn").getter(getter(DeleteEventSourceMappingResponse::eventSourceMappingArn))
            .setter(setter(Builder::eventSourceMappingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceMappingArn").build())
            .build();

    private static final SdkField<EventSourceMappingMetricsConfig> METRICS_CONFIG_FIELD = SdkField
            .<EventSourceMappingMetricsConfig> builder(MarshallingType.SDK_POJO).memberName("MetricsConfig")
            .getter(getter(DeleteEventSourceMappingResponse::metricsConfig)).setter(setter(Builder::metricsConfig))
            .constructor(EventSourceMappingMetricsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsConfig").build()).build();

    private static final SdkField<ProvisionedPollerConfig> PROVISIONED_POLLER_CONFIG_FIELD = SdkField
            .<ProvisionedPollerConfig> builder(MarshallingType.SDK_POJO).memberName("ProvisionedPollerConfig")
            .getter(getter(DeleteEventSourceMappingResponse::provisionedPollerConfig))
            .setter(setter(Builder::provisionedPollerConfig)).constructor(ProvisionedPollerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedPollerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD,
            STARTING_POSITION_FIELD, STARTING_POSITION_TIMESTAMP_FIELD, BATCH_SIZE_FIELD,
            MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, PARALLELIZATION_FACTOR_FIELD, EVENT_SOURCE_ARN_FIELD,
            FILTER_CRITERIA_FIELD, FUNCTION_ARN_FIELD, LAST_MODIFIED_FIELD, LAST_PROCESSING_RESULT_FIELD, STATE_FIELD,
            STATE_TRANSITION_REASON_FIELD, DESTINATION_CONFIG_FIELD, TOPICS_FIELD, QUEUES_FIELD,
            SOURCE_ACCESS_CONFIGURATIONS_FIELD, SELF_MANAGED_EVENT_SOURCE_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD,
            BISECT_BATCH_ON_FUNCTION_ERROR_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, TUMBLING_WINDOW_IN_SECONDS_FIELD,
            FUNCTION_RESPONSE_TYPES_FIELD, AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD,
            SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD, SCALING_CONFIG_FIELD, DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD,
            KMS_KEY_ARN_FIELD, FILTER_CRITERIA_ERROR_FIELD, EVENT_SOURCE_MAPPING_ARN_FIELD, METRICS_CONFIG_FIELD,
            PROVISIONED_POLLER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String uuid;

    private final String startingPosition;

    private final Instant startingPositionTimestamp;

    private final Integer batchSize;

    private final Integer maximumBatchingWindowInSeconds;

    private final Integer parallelizationFactor;

    private final String eventSourceArn;

    private final FilterCriteria filterCriteria;

    private final String functionArn;

    private final Instant lastModified;

    private final String lastProcessingResult;

    private final String state;

    private final String stateTransitionReason;

    private final DestinationConfig destinationConfig;

    private final List<String> topics;

    private final List<String> queues;

    private final List<SourceAccessConfiguration> sourceAccessConfigurations;

    private final SelfManagedEventSource selfManagedEventSource;

    private final Integer maximumRecordAgeInSeconds;

    private final Boolean bisectBatchOnFunctionError;

    private final Integer maximumRetryAttempts;

    private final Integer tumblingWindowInSeconds;

    private final List<String> functionResponseTypes;

    private final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;

    private final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;

    private final ScalingConfig scalingConfig;

    private final DocumentDBEventSourceConfig documentDBEventSourceConfig;

    private final String kmsKeyArn;

    private final FilterCriteriaError filterCriteriaError;

    private final String eventSourceMappingArn;

    private final EventSourceMappingMetricsConfig metricsConfig;

    private final ProvisionedPollerConfig provisionedPollerConfig;

    private DeleteEventSourceMappingResponse(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.eventSourceArn = builder.eventSourceArn;
        this.filterCriteria = builder.filterCriteria;
        this.functionArn = builder.functionArn;
        this.lastModified = builder.lastModified;
        this.lastProcessingResult = builder.lastProcessingResult;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.destinationConfig = builder.destinationConfig;
        this.topics = builder.topics;
        this.queues = builder.queues;
        this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
        this.selfManagedEventSource = builder.selfManagedEventSource;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        this.functionResponseTypes = builder.functionResponseTypes;
        this.amazonManagedKafkaEventSourceConfig = builder.amazonManagedKafkaEventSourceConfig;
        this.selfManagedKafkaEventSourceConfig = builder.selfManagedKafkaEventSourceConfig;
        this.scalingConfig = builder.scalingConfig;
        this.documentDBEventSourceConfig = builder.documentDBEventSourceConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.filterCriteriaError = builder.filterCriteriaError;
        this.eventSourceMappingArn = builder.eventSourceMappingArn;
        this.metricsConfig = builder.metricsConfig;
        this.provisionedPollerConfig = builder.provisionedPollerConfig;
    }

    /**
     * <p>
     * The identifier of the event source mapping.
     * </p>
     * 
     * @return The identifier of the event source mapping.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Stream
     * event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon DocumentDB, Amazon
     * MSK, and self-managed Apache Kafka.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link EventSourcePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB
     *         Stream event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon
     *         DocumentDB, Amazon MSK, and self-managed Apache Kafka.
     * @see EventSourcePosition
     */
    public final EventSourcePosition startingPosition() {
        return EventSourcePosition.fromValue(startingPosition);
    }

    /**
     * <p>
     * The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Stream
     * event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon DocumentDB, Amazon
     * MSK, and self-managed Apache Kafka.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link EventSourcePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB
     *         Stream event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon
     *         DocumentDB, Amazon MSK, and self-managed Apache Kafka.
     * @see EventSourcePosition
     */
    public final String startingPositionAsString() {
        return startingPosition;
    }

    /**
     * <p>
     * With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.
     * <code>StartingPositionTimestamp</code> cannot be in the future.
     * </p>
     * 
     * @return With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
     *         reading. <code>StartingPositionTimestamp</code> cannot be in the future.
     */
    public final Instant startingPositionTimestamp() {
        return startingPositionTimestamp;
    }

    /**
     * <p>
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
     * function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit
     * for synchronous invocation (6 MB).
     * </p>
     * <p>
     * Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.
     * </p>
     * <p>
     * Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
     * <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     * </p>
     * 
     * @return The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
     *         function. Lambda passes all of the records in the batch to the function in a single call, up to the
     *         payload limit for synchronous invocation (6 MB).</p>
     *         <p>
     *         Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default
     *         is 100.
     *         </p>
     *         <p>
     *         Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
     *         <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function. You
     * can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to 300 seconds in
     * increments of seconds.
     * </p>
     * <p>
     * For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK, Self-managed
     * Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500 ms. Note that because
     * you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of seconds, you cannot revert back
     * to the 500 ms default batching window after you have changed it. To restore the default batching window, you must
     * create a new event source mapping.
     * </p>
     * <p>
     * Related setting: For streams and Amazon SQS event sources, when you set <code>BatchSize</code> to a value greater
     * than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the
     *         function. You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to
     *         300 seconds in increments of seconds.</p>
     *         <p>
     *         For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK,
     *         Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500
     *         ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of
     *         seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To
     *         restore the default batching window, you must create a new event source mapping.
     *         </p>
     *         <p>
     *         Related setting: For streams and Amazon SQS event sources, when you set <code>BatchSize</code> to a value
     *         greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The default
     * value is 1.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The
     *         default value is 1.
     */
    public final Integer parallelizationFactor() {
        return parallelizationFactor;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event source.
     */
    public final String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * An object that defines the filter criteria that determine whether Lambda should process an event. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda
     * event filtering</a>.
     * </p>
     * <p>
     * If filter criteria is encrypted, this field shows up as <code>null</code> in the response of
     * ListEventSourceMapping API calls. You can view this field in plaintext in the response of GetEventSourceMapping
     * and DeleteEventSourceMapping calls if you have <code>kms:Decrypt</code> permissions for the correct KMS key.
     * </p>
     * 
     * @return An object that defines the filter criteria that determine whether Lambda should process an event. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event
     *         filtering</a>.</p>
     *         <p>
     *         If filter criteria is encrypted, this field shows up as <code>null</code> in the response of
     *         ListEventSourceMapping API calls. You can view this field in plaintext in the response of
     *         GetEventSourceMapping and DeleteEventSourceMapping calls if you have <code>kms:Decrypt</code> permissions
     *         for the correct KMS key.
     */
    public final FilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The ARN of the Lambda function.
     * </p>
     * 
     * @return The ARN of the Lambda function.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The date that the event source mapping was last updated or that its state changed.
     * </p>
     * 
     * @return The date that the event source mapping was last updated or that its state changed.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The result of the last Lambda invocation of your function.
     * </p>
     * 
     * @return The result of the last Lambda invocation of your function.
     */
    public final String lastProcessingResult() {
        return lastProcessingResult;
    }

    /**
     * <p>
     * The state of the event source mapping. It can be one of the following: <code>Creating</code>,
     * <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>
     * , or <code>Deleting</code>.
     * </p>
     * 
     * @return The state of the event source mapping. It can be one of the following: <code>Creating</code>,
     *         <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
     *         <code>Updating</code>, or <code>Deleting</code>.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * Indicates whether a user or Lambda made the last change to the event source mapping.
     * </p>
     * 
     * @return Indicates whether a user or Lambda made the last change to the event source mapping.
     */
    public final String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object
     * that specifies the destination of an event after Lambda processes it.
     * </p>
     * 
     * @return (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration
     *         object that specifies the destination of an event after Lambda processes it.
     */
    public final DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Topics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTopics() {
        return topics != null && !(topics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the Kafka topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopics} method.
     * </p>
     * 
     * @return The name of the Kafka topic.
     */
    public final List<String> topics() {
        return topics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueues() {
        return queues != null && !(queues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueues} method.
     * </p>
     * 
     * @return (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
     */
    public final List<String> queues() {
        return queues;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAccessConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceAccessConfigurations() {
        return sourceAccessConfigurations != null && !(sourceAccessConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAccessConfigurations} method.
     * </p>
     * 
     * @return An array of the authentication protocol, VPC components, or virtual host to secure and define your event
     *         source.
     */
    public final List<SourceAccessConfiguration> sourceAccessConfigurations() {
        return sourceAccessConfigurations;
    }

    /**
     * <p>
     * The self-managed Apache Kafka cluster for your event source.
     * </p>
     * 
     * @return The self-managed Apache Kafka cluster for your event source.
     */
    public final SelfManagedEventSource selfManagedEventSource() {
        return selfManagedEventSource;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1, which
     * sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
     * </p>
     * <note>
     * <p>
     * The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall
     * within the parameter's absolute range, they are not allowed
     * </p>
     * </note>
     * 
     * @return (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is
     *         -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old
     *         records.</p> <note>
     *         <p>
     *         The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1
     *         fall within the parameter's absolute range, they are not allowed
     *         </p>
     */
    public final Integer maximumRecordAgeInSeconds() {
        return maximumRecordAgeInSeconds;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The
     * default value is false.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.
     *         The default value is false.
     */
    public final Boolean bisectBatchOnFunctionError() {
        return bisectBatchOnFunctionError;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is
     * -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries
     * failed records until the record expires in the event source.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default
     *         value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite,
     *         Lambda retries failed records until the record expires in the event source.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis
     * Streams event sources. A value of 0 seconds indicates no tumbling window.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and
     *         Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
     */
    public final Integer tumblingWindowInSeconds() {
        return tumblingWindowInSeconds;
    }

    /**
     * <p>
     * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
     * mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionResponseTypes} method.
     * </p>
     * 
     * @return (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
     *         source mapping.
     */
    public final List<FunctionResponseType> functionResponseTypes() {
        return FunctionResponseTypeListCopier.copyStringToEnum(functionResponseTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionResponseTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFunctionResponseTypes() {
        return functionResponseTypes != null && !(functionResponseTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
     * mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionResponseTypes} method.
     * </p>
     * 
     * @return (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
     *         source mapping.
     */
    public final List<String> functionResponseTypesAsStrings() {
        return functionResponseTypes;
    }

    /**
     * <p>
     * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
     * </p>
     * 
     * @return Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event
     *         source.
     */
    public final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig() {
        return amazonManagedKafkaEventSourceConfig;
    }

    /**
     * <p>
     * Specific configuration settings for a self-managed Apache Kafka event source.
     * </p>
     * 
     * @return Specific configuration settings for a self-managed Apache Kafka event source.
     */
    public final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig() {
        return selfManagedKafkaEventSourceConfig;
    }

    /**
     * <p>
     * (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum
     * concurrency for Amazon SQS event sources</a>.
     * </p>
     * 
     * @return (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring
     *         maximum concurrency for Amazon SQS event sources</a>.
     */
    public final ScalingConfig scalingConfig() {
        return scalingConfig;
    }

    /**
     * <p>
     * Specific configuration settings for a DocumentDB event source.
     * </p>
     * 
     * @return Specific configuration settings for a DocumentDB event source.
     */
    public final DocumentDBEventSourceConfig documentDBEventSourceConfig() {
        return documentDBEventSourceConfig;
    }

    /**
     * <p>
     * The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics">filter
     * criteria</a>.
     * </p>
     * 
     * @return The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your
     *         function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics"
     *         >filter criteria</a>.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * An object that contains details about an error related to filter criteria encryption.
     * </p>
     * 
     * @return An object that contains details about an error related to filter criteria encryption.
     */
    public final FilterCriteriaError filterCriteriaError() {
        return filterCriteriaError;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event source mapping.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event source mapping.
     */
    public final String eventSourceMappingArn() {
        return eventSourceMappingArn;
    }

    /**
     * <p>
     * The metrics configuration for your event source. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
     * >Event source mapping metrics</a>.
     * </p>
     * 
     * @return The metrics configuration for your event source. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
     *         >Event source mapping metrics</a>.
     */
    public final EventSourceMappingMetricsConfig metricsConfig() {
        return metricsConfig;
    }

    /**
     * <p>
     * (Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode configuration for the event source. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
     * >Provisioned Mode</a>.
     * </p>
     * 
     * @return (Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode configuration for the event source.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
     *         >Provisioned Mode</a>.
     */
    public final ProvisionedPollerConfig provisionedPollerConfig() {
        return provisionedPollerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startingPositionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(lastProcessingResult());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTopics() ? topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueues() ? queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAccessConfigurations() ? sourceAccessConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(tumblingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionResponseTypes() ? functionResponseTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(amazonManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(documentDBEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteriaError());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceMappingArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedPollerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventSourceMappingResponse)) {
            return false;
        }
        DeleteEventSourceMappingResponse other = (DeleteEventSourceMappingResponse) obj;
        return Objects.equals(uuid(), other.uuid())
                && Objects.equals(startingPositionAsString(), other.startingPositionAsString())
                && Objects.equals(startingPositionTimestamp(), other.startingPositionTimestamp())
                && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(parallelizationFactor(), other.parallelizationFactor())
                && Objects.equals(eventSourceArn(), other.eventSourceArn())
                && Objects.equals(filterCriteria(), other.filterCriteria()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(lastProcessingResult(), other.lastProcessingResult()) && Objects.equals(state(), other.state())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason())
                && Objects.equals(destinationConfig(), other.destinationConfig()) && hasTopics() == other.hasTopics()
                && Objects.equals(topics(), other.topics()) && hasQueues() == other.hasQueues()
                && Objects.equals(queues(), other.queues())
                && hasSourceAccessConfigurations() == other.hasSourceAccessConfigurations()
                && Objects.equals(sourceAccessConfigurations(), other.sourceAccessConfigurations())
                && Objects.equals(selfManagedEventSource(), other.selfManagedEventSource())
                && Objects.equals(maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds())
                && Objects.equals(bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts())
                && Objects.equals(tumblingWindowInSeconds(), other.tumblingWindowInSeconds())
                && hasFunctionResponseTypes() == other.hasFunctionResponseTypes()
                && Objects.equals(functionResponseTypesAsStrings(), other.functionResponseTypesAsStrings())
                && Objects.equals(amazonManagedKafkaEventSourceConfig(), other.amazonManagedKafkaEventSourceConfig())
                && Objects.equals(selfManagedKafkaEventSourceConfig(), other.selfManagedKafkaEventSourceConfig())
                && Objects.equals(scalingConfig(), other.scalingConfig())
                && Objects.equals(documentDBEventSourceConfig(), other.documentDBEventSourceConfig())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(filterCriteriaError(), other.filterCriteriaError())
                && Objects.equals(eventSourceMappingArn(), other.eventSourceMappingArn())
                && Objects.equals(metricsConfig(), other.metricsConfig())
                && Objects.equals(provisionedPollerConfig(), other.provisionedPollerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEventSourceMappingResponse").add("UUID", uuid())
                .add("StartingPosition", startingPositionAsString())
                .add("StartingPositionTimestamp", startingPositionTimestamp()).add("BatchSize", batchSize())
                .add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("ParallelizationFactor", parallelizationFactor()).add("EventSourceArn", eventSourceArn())
                .add("FilterCriteria", filterCriteria()).add("FunctionArn", functionArn()).add("LastModified", lastModified())
                .add("LastProcessingResult", lastProcessingResult()).add("State", state())
                .add("StateTransitionReason", stateTransitionReason()).add("DestinationConfig", destinationConfig())
                .add("Topics", hasTopics() ? topics() : null).add("Queues", hasQueues() ? queues() : null)
                .add("SourceAccessConfigurations", hasSourceAccessConfigurations() ? sourceAccessConfigurations() : null)
                .add("SelfManagedEventSource", selfManagedEventSource())
                .add("MaximumRecordAgeInSeconds", maximumRecordAgeInSeconds())
                .add("BisectBatchOnFunctionError", bisectBatchOnFunctionError())
                .add("MaximumRetryAttempts", maximumRetryAttempts()).add("TumblingWindowInSeconds", tumblingWindowInSeconds())
                .add("FunctionResponseTypes", hasFunctionResponseTypes() ? functionResponseTypesAsStrings() : null)
                .add("AmazonManagedKafkaEventSourceConfig", amazonManagedKafkaEventSourceConfig())
                .add("SelfManagedKafkaEventSourceConfig", selfManagedKafkaEventSourceConfig())
                .add("ScalingConfig", scalingConfig()).add("DocumentDBEventSourceConfig", documentDBEventSourceConfig())
                .add("KMSKeyArn", kmsKeyArn()).add("FilterCriteriaError", filterCriteriaError())
                .add("EventSourceMappingArn", eventSourceMappingArn()).add("MetricsConfig", metricsConfig())
                .add("ProvisionedPollerConfig", provisionedPollerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "StartingPosition":
            return Optional.ofNullable(clazz.cast(startingPositionAsString()));
        case "StartingPositionTimestamp":
            return Optional.ofNullable(clazz.cast(startingPositionTimestamp()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "ParallelizationFactor":
            return Optional.ofNullable(clazz.cast(parallelizationFactor()));
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "FilterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "LastProcessingResult":
            return Optional.ofNullable(clazz.cast(lastProcessingResult()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateTransitionReason":
            return Optional.ofNullable(clazz.cast(stateTransitionReason()));
        case "DestinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        case "Topics":
            return Optional.ofNullable(clazz.cast(topics()));
        case "Queues":
            return Optional.ofNullable(clazz.cast(queues()));
        case "SourceAccessConfigurations":
            return Optional.ofNullable(clazz.cast(sourceAccessConfigurations()));
        case "SelfManagedEventSource":
            return Optional.ofNullable(clazz.cast(selfManagedEventSource()));
        case "MaximumRecordAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumRecordAgeInSeconds()));
        case "BisectBatchOnFunctionError":
            return Optional.ofNullable(clazz.cast(bisectBatchOnFunctionError()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        case "TumblingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(tumblingWindowInSeconds()));
        case "FunctionResponseTypes":
            return Optional.ofNullable(clazz.cast(functionResponseTypesAsStrings()));
        case "AmazonManagedKafkaEventSourceConfig":
            return Optional.ofNullable(clazz.cast(amazonManagedKafkaEventSourceConfig()));
        case "SelfManagedKafkaEventSourceConfig":
            return Optional.ofNullable(clazz.cast(selfManagedKafkaEventSourceConfig()));
        case "ScalingConfig":
            return Optional.ofNullable(clazz.cast(scalingConfig()));
        case "DocumentDBEventSourceConfig":
            return Optional.ofNullable(clazz.cast(documentDBEventSourceConfig()));
        case "KMSKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "FilterCriteriaError":
            return Optional.ofNullable(clazz.cast(filterCriteriaError()));
        case "EventSourceMappingArn":
            return Optional.ofNullable(clazz.cast(eventSourceMappingArn()));
        case "MetricsConfig":
            return Optional.ofNullable(clazz.cast(metricsConfig()));
        case "ProvisionedPollerConfig":
            return Optional.ofNullable(clazz.cast(provisionedPollerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UUID", UUID_FIELD);
        map.put("StartingPosition", STARTING_POSITION_FIELD);
        map.put("StartingPositionTimestamp", STARTING_POSITION_TIMESTAMP_FIELD);
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        map.put("ParallelizationFactor", PARALLELIZATION_FACTOR_FIELD);
        map.put("EventSourceArn", EVENT_SOURCE_ARN_FIELD);
        map.put("FilterCriteria", FILTER_CRITERIA_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        map.put("LastProcessingResult", LAST_PROCESSING_RESULT_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateTransitionReason", STATE_TRANSITION_REASON_FIELD);
        map.put("DestinationConfig", DESTINATION_CONFIG_FIELD);
        map.put("Topics", TOPICS_FIELD);
        map.put("Queues", QUEUES_FIELD);
        map.put("SourceAccessConfigurations", SOURCE_ACCESS_CONFIGURATIONS_FIELD);
        map.put("SelfManagedEventSource", SELF_MANAGED_EVENT_SOURCE_FIELD);
        map.put("MaximumRecordAgeInSeconds", MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD);
        map.put("BisectBatchOnFunctionError", BISECT_BATCH_ON_FUNCTION_ERROR_FIELD);
        map.put("MaximumRetryAttempts", MAXIMUM_RETRY_ATTEMPTS_FIELD);
        map.put("TumblingWindowInSeconds", TUMBLING_WINDOW_IN_SECONDS_FIELD);
        map.put("FunctionResponseTypes", FUNCTION_RESPONSE_TYPES_FIELD);
        map.put("AmazonManagedKafkaEventSourceConfig", AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD);
        map.put("SelfManagedKafkaEventSourceConfig", SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD);
        map.put("ScalingConfig", SCALING_CONFIG_FIELD);
        map.put("DocumentDBEventSourceConfig", DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD);
        map.put("KMSKeyArn", KMS_KEY_ARN_FIELD);
        map.put("FilterCriteriaError", FILTER_CRITERIA_ERROR_FIELD);
        map.put("EventSourceMappingArn", EVENT_SOURCE_MAPPING_ARN_FIELD);
        map.put("MetricsConfig", METRICS_CONFIG_FIELD);
        map.put("ProvisionedPollerConfig", PROVISIONED_POLLER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteEventSourceMappingResponse, T> g) {
        return obj -> g.apply((DeleteEventSourceMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEventSourceMappingResponse> {
        /**
         * <p>
         * The identifier of the event source mapping.
         * </p>
         * 
         * @param uuid
         *        The identifier of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Stream
         * event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon DocumentDB,
         * Amazon MSK, and self-managed Apache Kafka.
         * </p>
         * 
         * @param startingPosition
         *        The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB
         *        Stream event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon
         *        DocumentDB, Amazon MSK, and self-managed Apache Kafka.
         * @see EventSourcePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourcePosition
         */
        Builder startingPosition(String startingPosition);

        /**
         * <p>
         * The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB Stream
         * event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon DocumentDB,
         * Amazon MSK, and self-managed Apache Kafka.
         * </p>
         * 
         * @param startingPosition
         *        The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB
         *        Stream event sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams, Amazon
         *        DocumentDB, Amazon MSK, and self-managed Apache Kafka.
         * @see EventSourcePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourcePosition
         */
        Builder startingPosition(EventSourcePosition startingPosition);

        /**
         * <p>
         * With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.
         * <code>StartingPositionTimestamp</code> cannot be in the future.
         * </p>
         * 
         * @param startingPositionTimestamp
         *        With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
         *        reading. <code>StartingPositionTimestamp</code> cannot be in the future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingPositionTimestamp(Instant startingPositionTimestamp);

        /**
         * <p>
         * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
         * function. Lambda passes all of the records in the batch to the function in a single call, up to the payload
         * limit for synchronous invocation (6 MB).
         * </p>
         * <p>
         * Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is
         * 100.
         * </p>
         * <p>
         * Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
         * <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to
         *        your function. Lambda passes all of the records in the batch to the function in a single call, up to
         *        the payload limit for synchronous invocation (6 MB).</p>
         *        <p>
         *        Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the
         *        default is 100.
         *        </p>
         *        <p>
         *        Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
         *        <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         * You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to 300 seconds in
         * increments of seconds.
         * </p>
         * <p>
         * For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK,
         * Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500 ms.
         * Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of seconds,
         * you cannot revert back to the 500 ms default batching window after you have changed it. To restore the
         * default batching window, you must create a new event source mapping.
         * </p>
         * <p>
         * Related setting: For streams and Amazon SQS event sources, when you set <code>BatchSize</code> to a value
         * greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the
         *        function. You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to
         *        300 seconds in increments of seconds.</p>
         *        <p>
         *        For streams and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK,
         *        Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500
         *        ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of
         *        seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To
         *        restore the default batching window, you must create a new event source mapping.
         *        </p>
         *        <p>
         *        Related setting: For streams and Amazon SQS event sources, when you set <code>BatchSize</code> to a
         *        value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The
         * default value is 1.
         * </p>
         * 
         * @param parallelizationFactor
         *        (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The
         *        default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelizationFactor(Integer parallelizationFactor);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event source.
         * </p>
         * 
         * @param eventSourceArn
         *        The Amazon Resource Name (ARN) of the event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * An object that defines the filter criteria that determine whether Lambda should process an event. For more
         * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda
         * event filtering</a>.
         * </p>
         * <p>
         * If filter criteria is encrypted, this field shows up as <code>null</code> in the response of
         * ListEventSourceMapping API calls. You can view this field in plaintext in the response of
         * GetEventSourceMapping and DeleteEventSourceMapping calls if you have <code>kms:Decrypt</code> permissions for
         * the correct KMS key.
         * </p>
         * 
         * @param filterCriteria
         *        An object that defines the filter criteria that determine whether Lambda should process an event. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event
         *        filtering</a>.</p>
         *        <p>
         *        If filter criteria is encrypted, this field shows up as <code>null</code> in the response of
         *        ListEventSourceMapping API calls. You can view this field in plaintext in the response of
         *        GetEventSourceMapping and DeleteEventSourceMapping calls if you have <code>kms:Decrypt</code>
         *        permissions for the correct KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(FilterCriteria filterCriteria);

        /**
         * <p>
         * An object that defines the filter criteria that determine whether Lambda should process an event. For more
         * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda
         * event filtering</a>.
         * </p>
         * <p>
         * If filter criteria is encrypted, this field shows up as <code>null</code> in the response of
         * ListEventSourceMapping API calls. You can view this field in plaintext in the response of
         * GetEventSourceMapping and DeleteEventSourceMapping calls if you have <code>kms:Decrypt</code> permissions for
         * the correct KMS key.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteria.Builder} avoiding the need
         * to create one manually via {@link FilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCriteria(FilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link FilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(FilterCriteria)
         */
        default Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return filterCriteria(FilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The ARN of the Lambda function.
         * </p>
         * 
         * @param functionArn
         *        The ARN of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The date that the event source mapping was last updated or that its state changed.
         * </p>
         * 
         * @param lastModified
         *        The date that the event source mapping was last updated or that its state changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The result of the last Lambda invocation of your function.
         * </p>
         * 
         * @param lastProcessingResult
         *        The result of the last Lambda invocation of your function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastProcessingResult(String lastProcessingResult);

        /**
         * <p>
         * The state of the event source mapping. It can be one of the following: <code>Creating</code>,
         * <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
         * <code>Updating</code>, or <code>Deleting</code>.
         * </p>
         * 
         * @param state
         *        The state of the event source mapping. It can be one of the following: <code>Creating</code>,
         *        <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
         *        <code>Updating</code>, or <code>Deleting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates whether a user or Lambda made the last change to the event source mapping.
         * </p>
         * 
         * @param stateTransitionReason
         *        Indicates whether a user or Lambda made the last change to the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration
         * object that specifies the destination of an event after Lambda processes it.
         * </p>
         * 
         * @param destinationConfig
         *        (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A
         *        configuration object that specifies the destination of an event after Lambda processes it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration
         * object that specifies the destination of an event after Lambda processes it.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfig.Builder} avoiding the
         * need to create one manually via {@link DestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        /**
         * <p>
         * The name of the Kafka topic.
         * </p>
         * 
         * @param topics
         *        The name of the Kafka topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Collection<String> topics);

        /**
         * <p>
         * The name of the Kafka topic.
         * </p>
         * 
         * @param topics
         *        The name of the Kafka topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(String... topics);

        /**
         * <p>
         * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
         * </p>
         * 
         * @param queues
         *        (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Collection<String> queues);

        /**
         * <p>
         * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
         * </p>
         * 
         * @param queues
         *        (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(String... queues);

        /**
         * <p>
         * An array of the authentication protocol, VPC components, or virtual host to secure and define your event
         * source.
         * </p>
         * 
         * @param sourceAccessConfigurations
         *        An array of the authentication protocol, VPC components, or virtual host to secure and define your
         *        event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations);

        /**
         * <p>
         * An array of the authentication protocol, VPC components, or virtual host to secure and define your event
         * source.
         * </p>
         * 
         * @param sourceAccessConfigurations
         *        An array of the authentication protocol, VPC components, or virtual host to secure and define your
         *        event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessConfigurations(SourceAccessConfiguration... sourceAccessConfigurations);

        /**
         * <p>
         * An array of the authentication protocol, VPC components, or virtual host to secure and define your event
         * source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAccessConfigurations(List<SourceAccessConfiguration>)}.
         * 
         * @param sourceAccessConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAccessConfigurations(java.util.Collection<SourceAccessConfiguration>)
         */
        Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder>... sourceAccessConfigurations);

        /**
         * <p>
         * The self-managed Apache Kafka cluster for your event source.
         * </p>
         * 
         * @param selfManagedEventSource
         *        The self-managed Apache Kafka cluster for your event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedEventSource(SelfManagedEventSource selfManagedEventSource);

        /**
         * <p>
         * The self-managed Apache Kafka cluster for your event source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelfManagedEventSource.Builder} avoiding
         * the need to create one manually via {@link SelfManagedEventSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedEventSource.Builder#build()} is called immediately and
         * its result is passed to {@link #selfManagedEventSource(SelfManagedEventSource)}.
         * 
         * @param selfManagedEventSource
         *        a consumer that will call methods on {@link SelfManagedEventSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedEventSource(SelfManagedEventSource)
         */
        default Builder selfManagedEventSource(Consumer<SelfManagedEventSource.Builder> selfManagedEventSource) {
            return selfManagedEventSource(SelfManagedEventSource.builder().applyMutation(selfManagedEventSource).build());
        }

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1,
         * which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
         * </p>
         * <note>
         * <p>
         * The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall
         * within the parameter's absolute range, they are not allowed
         * </p>
         * </note>
         * 
         * @param maximumRecordAgeInSeconds
         *        (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is
         *        -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards
         *        old records.</p> <note>
         *        <p>
         *        The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than
         *        -1 fall within the parameter's absolute range, they are not allowed
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The
         * default value is false.
         * </p>
         * 
         * @param bisectBatchOnFunctionError
         *        (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and
         *        retry. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value
         * is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda
         * retries failed records until the record expires in the event source.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default
         *        value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is
         *        infinite, Lambda retries failed records until the record expires in the event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis
         * Streams event sources. A value of 0 seconds indicates no tumbling window.
         * </p>
         * 
         * @param tumblingWindowInSeconds
         *        (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and
         *        Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypesWithStrings(String... functionResponseTypes);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypes(FunctionResponseType... functionResponseTypes);

        /**
         * <p>
         * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
         * </p>
         * 
         * @param amazonManagedKafkaEventSourceConfig
         *        Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig);

        /**
         * <p>
         * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonManagedKafkaEventSourceConfig.Builder} avoiding the need to create one manually via
         * {@link AmazonManagedKafkaEventSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonManagedKafkaEventSourceConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig)}.
         * 
         * @param amazonManagedKafkaEventSourceConfig
         *        a consumer that will call methods on {@link AmazonManagedKafkaEventSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig)
         */
        default Builder amazonManagedKafkaEventSourceConfig(
                Consumer<AmazonManagedKafkaEventSourceConfig.Builder> amazonManagedKafkaEventSourceConfig) {
            return amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig.builder()
                    .applyMutation(amazonManagedKafkaEventSourceConfig).build());
        }

        /**
         * <p>
         * Specific configuration settings for a self-managed Apache Kafka event source.
         * </p>
         * 
         * @param selfManagedKafkaEventSourceConfig
         *        Specific configuration settings for a self-managed Apache Kafka event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig);

        /**
         * <p>
         * Specific configuration settings for a self-managed Apache Kafka event source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SelfManagedKafkaEventSourceConfig.Builder} avoiding the need to create one manually via
         * {@link SelfManagedKafkaEventSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedKafkaEventSourceConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig)}.
         * 
         * @param selfManagedKafkaEventSourceConfig
         *        a consumer that will call methods on {@link SelfManagedKafkaEventSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig)
         */
        default Builder selfManagedKafkaEventSourceConfig(
                Consumer<SelfManagedKafkaEventSourceConfig.Builder> selfManagedKafkaEventSourceConfig) {
            return selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig.builder()
                    .applyMutation(selfManagedKafkaEventSourceConfig).build());
        }

        /**
         * <p>
         * (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring
         * maximum concurrency for Amazon SQS event sources</a>.
         * </p>
         * 
         * @param scalingConfig
         *        (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency"
         *        >Configuring maximum concurrency for Amazon SQS event sources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfig(ScalingConfig scalingConfig);

        /**
         * <p>
         * (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring
         * maximum concurrency for Amazon SQS event sources</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfig.Builder} avoiding the need
         * to create one manually via {@link ScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #scalingConfig(ScalingConfig)}.
         * 
         * @param scalingConfig
         *        a consumer that will call methods on {@link ScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfig(ScalingConfig)
         */
        default Builder scalingConfig(Consumer<ScalingConfig.Builder> scalingConfig) {
            return scalingConfig(ScalingConfig.builder().applyMutation(scalingConfig).build());
        }

        /**
         * <p>
         * Specific configuration settings for a DocumentDB event source.
         * </p>
         * 
         * @param documentDBEventSourceConfig
         *        Specific configuration settings for a DocumentDB event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig documentDBEventSourceConfig);

        /**
         * <p>
         * Specific configuration settings for a DocumentDB event source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentDBEventSourceConfig.Builder}
         * avoiding the need to create one manually via {@link DocumentDBEventSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentDBEventSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #documentDBEventSourceConfig(DocumentDBEventSourceConfig)}.
         * 
         * @param documentDBEventSourceConfig
         *        a consumer that will call methods on {@link DocumentDBEventSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentDBEventSourceConfig(DocumentDBEventSourceConfig)
         */
        default Builder documentDBEventSourceConfig(Consumer<DocumentDBEventSourceConfig.Builder> documentDBEventSourceConfig) {
            return documentDBEventSourceConfig(DocumentDBEventSourceConfig.builder().applyMutation(documentDBEventSourceConfig)
                    .build());
        }

        /**
         * <p>
         * The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's
         * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics">filter
         * criteria</a>.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your
         *        function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics"
         *        >filter criteria</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * An object that contains details about an error related to filter criteria encryption.
         * </p>
         * 
         * @param filterCriteriaError
         *        An object that contains details about an error related to filter criteria encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteriaError(FilterCriteriaError filterCriteriaError);

        /**
         * <p>
         * An object that contains details about an error related to filter criteria encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteriaError.Builder} avoiding the
         * need to create one manually via {@link FilterCriteriaError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCriteriaError.Builder#build()} is called immediately and
         * its result is passed to {@link #filterCriteriaError(FilterCriteriaError)}.
         * 
         * @param filterCriteriaError
         *        a consumer that will call methods on {@link FilterCriteriaError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteriaError(FilterCriteriaError)
         */
        default Builder filterCriteriaError(Consumer<FilterCriteriaError.Builder> filterCriteriaError) {
            return filterCriteriaError(FilterCriteriaError.builder().applyMutation(filterCriteriaError).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event source mapping.
         * </p>
         * 
         * @param eventSourceMappingArn
         *        The Amazon Resource Name (ARN) of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceMappingArn(String eventSourceMappingArn);

        /**
         * <p>
         * The metrics configuration for your event source. For more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         * >Event source mapping metrics</a>.
         * </p>
         * 
         * @param metricsConfig
         *        The metrics configuration for your event source. For more information, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         *        >Event source mapping metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsConfig(EventSourceMappingMetricsConfig metricsConfig);

        /**
         * <p>
         * The metrics configuration for your event source. For more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         * >Event source mapping metrics</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventSourceMappingMetricsConfig.Builder}
         * avoiding the need to create one manually via {@link EventSourceMappingMetricsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventSourceMappingMetricsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #metricsConfig(EventSourceMappingMetricsConfig)}.
         * 
         * @param metricsConfig
         *        a consumer that will call methods on {@link EventSourceMappingMetricsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsConfig(EventSourceMappingMetricsConfig)
         */
        default Builder metricsConfig(Consumer<EventSourceMappingMetricsConfig.Builder> metricsConfig) {
            return metricsConfig(EventSourceMappingMetricsConfig.builder().applyMutation(metricsConfig).build());
        }

        /**
         * <p>
         * (Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode configuration for the event source. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
         * >Provisioned Mode</a>.
         * </p>
         * 
         * @param provisionedPollerConfig
         *        (Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode configuration for the event
         *        source. For more information, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
         *        >Provisioned Mode</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedPollerConfig(ProvisionedPollerConfig provisionedPollerConfig);

        /**
         * <p>
         * (Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode configuration for the event source. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
         * >Provisioned Mode</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedPollerConfig.Builder} avoiding
         * the need to create one manually via {@link ProvisionedPollerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedPollerConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionedPollerConfig(ProvisionedPollerConfig)}.
         * 
         * @param provisionedPollerConfig
         *        a consumer that will call methods on {@link ProvisionedPollerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedPollerConfig(ProvisionedPollerConfig)
         */
        default Builder provisionedPollerConfig(Consumer<ProvisionedPollerConfig.Builder> provisionedPollerConfig) {
            return provisionedPollerConfig(ProvisionedPollerConfig.builder().applyMutation(provisionedPollerConfig).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String uuid;

        private String startingPosition;

        private Instant startingPositionTimestamp;

        private Integer batchSize;

        private Integer maximumBatchingWindowInSeconds;

        private Integer parallelizationFactor;

        private String eventSourceArn;

        private FilterCriteria filterCriteria;

        private String functionArn;

        private Instant lastModified;

        private String lastProcessingResult;

        private String state;

        private String stateTransitionReason;

        private DestinationConfig destinationConfig;

        private List<String> topics = DefaultSdkAutoConstructList.getInstance();

        private List<String> queues = DefaultSdkAutoConstructList.getInstance();

        private List<SourceAccessConfiguration> sourceAccessConfigurations = DefaultSdkAutoConstructList.getInstance();

        private SelfManagedEventSource selfManagedEventSource;

        private Integer maximumRecordAgeInSeconds;

        private Boolean bisectBatchOnFunctionError;

        private Integer maximumRetryAttempts;

        private Integer tumblingWindowInSeconds;

        private List<String> functionResponseTypes = DefaultSdkAutoConstructList.getInstance();

        private AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;

        private SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;

        private ScalingConfig scalingConfig;

        private DocumentDBEventSourceConfig documentDBEventSourceConfig;

        private String kmsKeyArn;

        private FilterCriteriaError filterCriteriaError;

        private String eventSourceMappingArn;

        private EventSourceMappingMetricsConfig metricsConfig;

        private ProvisionedPollerConfig provisionedPollerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventSourceMappingResponse model) {
            super(model);
            uuid(model.uuid);
            startingPosition(model.startingPosition);
            startingPositionTimestamp(model.startingPositionTimestamp);
            batchSize(model.batchSize);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            parallelizationFactor(model.parallelizationFactor);
            eventSourceArn(model.eventSourceArn);
            filterCriteria(model.filterCriteria);
            functionArn(model.functionArn);
            lastModified(model.lastModified);
            lastProcessingResult(model.lastProcessingResult);
            state(model.state);
            stateTransitionReason(model.stateTransitionReason);
            destinationConfig(model.destinationConfig);
            topics(model.topics);
            queues(model.queues);
            sourceAccessConfigurations(model.sourceAccessConfigurations);
            selfManagedEventSource(model.selfManagedEventSource);
            maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            maximumRetryAttempts(model.maximumRetryAttempts);
            tumblingWindowInSeconds(model.tumblingWindowInSeconds);
            functionResponseTypesWithStrings(model.functionResponseTypes);
            amazonManagedKafkaEventSourceConfig(model.amazonManagedKafkaEventSourceConfig);
            selfManagedKafkaEventSourceConfig(model.selfManagedKafkaEventSourceConfig);
            scalingConfig(model.scalingConfig);
            documentDBEventSourceConfig(model.documentDBEventSourceConfig);
            kmsKeyArn(model.kmsKeyArn);
            filterCriteriaError(model.filterCriteriaError);
            eventSourceMappingArn(model.eventSourceMappingArn);
            metricsConfig(model.metricsConfig);
            provisionedPollerConfig(model.provisionedPollerConfig);
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getStartingPosition() {
            return startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final Instant getStartingPositionTimestamp() {
            return startingPositionTimestamp;
        }

        public final void setStartingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getLastProcessingResult() {
            return lastProcessingResult;
        }

        public final void setLastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
        }

        @Override
        public final Builder lastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final Collection<String> getTopics() {
            if (topics instanceof SdkAutoConstructList) {
                return null;
            }
            return topics;
        }

        public final void setTopics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
        }

        @Override
        public final Builder topics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(String... topics) {
            topics(Arrays.asList(topics));
            return this;
        }

        public final Collection<String> getQueues() {
            if (queues instanceof SdkAutoConstructList) {
                return null;
            }
            return queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String... queues) {
            queues(Arrays.asList(queues));
            return this;
        }

        public final List<SourceAccessConfiguration.Builder> getSourceAccessConfigurations() {
            List<SourceAccessConfiguration.Builder> result = SourceAccessConfigurationsCopier
                    .copyToBuilder(this.sourceAccessConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAccessConfigurations(
                Collection<SourceAccessConfiguration.BuilderImpl> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copyFromBuilder(sourceAccessConfigurations);
        }

        @Override
        public final Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copy(sourceAccessConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(SourceAccessConfiguration... sourceAccessConfigurations) {
            sourceAccessConfigurations(Arrays.asList(sourceAccessConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder>... sourceAccessConfigurations) {
            sourceAccessConfigurations(Stream.of(sourceAccessConfigurations)
                    .map(c -> SourceAccessConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SelfManagedEventSource.Builder getSelfManagedEventSource() {
            return selfManagedEventSource != null ? selfManagedEventSource.toBuilder() : null;
        }

        public final void setSelfManagedEventSource(SelfManagedEventSource.BuilderImpl selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource != null ? selfManagedEventSource.build() : null;
        }

        @Override
        public final Builder selfManagedEventSource(SelfManagedEventSource selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return bisectBatchOnFunctionError;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        @Override
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getTumblingWindowInSeconds() {
            return tumblingWindowInSeconds;
        }

        public final void setTumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
        }

        @Override
        public final Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        public final Collection<String> getFunctionResponseTypes() {
            if (functionResponseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return functionResponseTypes;
        }

        public final void setFunctionResponseTypes(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
        }

        @Override
        public final Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypesWithStrings(String... functionResponseTypes) {
            functionResponseTypesWithStrings(Arrays.asList(functionResponseTypes));
            return this;
        }

        @Override
        public final Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copyEnumToString(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypes(FunctionResponseType... functionResponseTypes) {
            functionResponseTypes(Arrays.asList(functionResponseTypes));
            return this;
        }

        public final AmazonManagedKafkaEventSourceConfig.Builder getAmazonManagedKafkaEventSourceConfig() {
            return amazonManagedKafkaEventSourceConfig != null ? amazonManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setAmazonManagedKafkaEventSourceConfig(
                AmazonManagedKafkaEventSourceConfig.BuilderImpl amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig != null ? amazonManagedKafkaEventSourceConfig
                    .build() : null;
        }

        @Override
        public final Builder amazonManagedKafkaEventSourceConfig(
                AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        public final SelfManagedKafkaEventSourceConfig.Builder getSelfManagedKafkaEventSourceConfig() {
            return selfManagedKafkaEventSourceConfig != null ? selfManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setSelfManagedKafkaEventSourceConfig(
                SelfManagedKafkaEventSourceConfig.BuilderImpl selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig != null ? selfManagedKafkaEventSourceConfig
                    .build() : null;
        }

        @Override
        public final Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        public final ScalingConfig.Builder getScalingConfig() {
            return scalingConfig != null ? scalingConfig.toBuilder() : null;
        }

        public final void setScalingConfig(ScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        @Override
        public final Builder scalingConfig(ScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final DocumentDBEventSourceConfig.Builder getDocumentDBEventSourceConfig() {
            return documentDBEventSourceConfig != null ? documentDBEventSourceConfig.toBuilder() : null;
        }

        public final void setDocumentDBEventSourceConfig(DocumentDBEventSourceConfig.BuilderImpl documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig != null ? documentDBEventSourceConfig.build() : null;
        }

        @Override
        public final Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final FilterCriteriaError.Builder getFilterCriteriaError() {
            return filterCriteriaError != null ? filterCriteriaError.toBuilder() : null;
        }

        public final void setFilterCriteriaError(FilterCriteriaError.BuilderImpl filterCriteriaError) {
            this.filterCriteriaError = filterCriteriaError != null ? filterCriteriaError.build() : null;
        }

        @Override
        public final Builder filterCriteriaError(FilterCriteriaError filterCriteriaError) {
            this.filterCriteriaError = filterCriteriaError;
            return this;
        }

        public final String getEventSourceMappingArn() {
            return eventSourceMappingArn;
        }

        public final void setEventSourceMappingArn(String eventSourceMappingArn) {
            this.eventSourceMappingArn = eventSourceMappingArn;
        }

        @Override
        public final Builder eventSourceMappingArn(String eventSourceMappingArn) {
            this.eventSourceMappingArn = eventSourceMappingArn;
            return this;
        }

        public final EventSourceMappingMetricsConfig.Builder getMetricsConfig() {
            return metricsConfig != null ? metricsConfig.toBuilder() : null;
        }

        public final void setMetricsConfig(EventSourceMappingMetricsConfig.BuilderImpl metricsConfig) {
            this.metricsConfig = metricsConfig != null ? metricsConfig.build() : null;
        }

        @Override
        public final Builder metricsConfig(EventSourceMappingMetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        public final ProvisionedPollerConfig.Builder getProvisionedPollerConfig() {
            return provisionedPollerConfig != null ? provisionedPollerConfig.toBuilder() : null;
        }

        public final void setProvisionedPollerConfig(ProvisionedPollerConfig.BuilderImpl provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig != null ? provisionedPollerConfig.build() : null;
        }

        @Override
        public final Builder provisionedPollerConfig(ProvisionedPollerConfig provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        @Override
        public DeleteEventSourceMappingResponse build() {
            return new DeleteEventSourceMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
