/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndPointType {
    KAFKA_BOOTSTRAP_SERVERS("KAFKA_BOOTSTRAP_SERVERS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndPointType> VALUE_MAP;
    private final String value;

    private EndPointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndPointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndPointType> knownValues() {
        EnumSet<EndPointType> knownValues = EnumSet.allOf(EndPointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndPointType.class, EndPointType::toString);
    }
}

