/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoTuneType {
    SCHEDULED_ACTION("SCHEDULED_ACTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoTuneType> VALUE_MAP;
    private final String value;

    private AutoTuneType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoTuneType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoTuneType> knownValues() {
        EnumSet<AutoTuneType> knownValues = EnumSet.allOf(AutoTuneType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoTuneType.class, AutoTuneType::toString);
    }
}

