/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.RolesKeyIdCOption;
import software.amazon.awssdk.services.opensearch.model.SubjectKeyIdCOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityCenterOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityCenterOptionsInput> {
    private static final SdkField<Boolean> ENABLED_API_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnabledAPIAccess").getter(IdentityCenterOptionsInput.getter(IdentityCenterOptionsInput::enabledAPIAccess)).setter(IdentityCenterOptionsInput.setter(Builder::enabledAPIAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledAPIAccess").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityCenterInstanceARN").getter(IdentityCenterOptionsInput.getter(IdentityCenterOptionsInput::identityCenterInstanceARN)).setter(IdentityCenterOptionsInput.setter(Builder::identityCenterInstanceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterInstanceARN").build()}).build();
    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectKey").getter(IdentityCenterOptionsInput.getter(IdentityCenterOptionsInput::subjectKeyAsString)).setter(IdentityCenterOptionsInput.setter(Builder::subjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()}).build();
    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RolesKey").getter(IdentityCenterOptionsInput.getter(IdentityCenterOptionsInput::rolesKeyAsString)).setter(IdentityCenterOptionsInput.setter(Builder::rolesKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_API_ACCESS_FIELD, IDENTITY_CENTER_INSTANCE_ARN_FIELD, SUBJECT_KEY_FIELD, ROLES_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdentityCenterOptionsInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabledAPIAccess;
    private final String identityCenterInstanceARN;
    private final String subjectKey;
    private final String rolesKey;

    private IdentityCenterOptionsInput(BuilderImpl builder) {
        this.enabledAPIAccess = builder.enabledAPIAccess;
        this.identityCenterInstanceARN = builder.identityCenterInstanceARN;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
    }

    public final Boolean enabledAPIAccess() {
        return this.enabledAPIAccess;
    }

    public final String identityCenterInstanceARN() {
        return this.identityCenterInstanceARN;
    }

    public final SubjectKeyIdCOption subjectKey() {
        return SubjectKeyIdCOption.fromValue(this.subjectKey);
    }

    public final String subjectKeyAsString() {
        return this.subjectKey;
    }

    public final RolesKeyIdCOption rolesKey() {
        return RolesKeyIdCOption.fromValue(this.rolesKey);
    }

    public final String rolesKeyAsString() {
        return this.rolesKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledAPIAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterInstanceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolesKeyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityCenterOptionsInput)) {
            return false;
        }
        IdentityCenterOptionsInput other = (IdentityCenterOptionsInput)obj;
        return Objects.equals(this.enabledAPIAccess(), other.enabledAPIAccess()) && Objects.equals(this.identityCenterInstanceARN(), other.identityCenterInstanceARN()) && Objects.equals(this.subjectKeyAsString(), other.subjectKeyAsString()) && Objects.equals(this.rolesKeyAsString(), other.rolesKeyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityCenterOptionsInput").add("EnabledAPIAccess", (Object)this.enabledAPIAccess()).add("IdentityCenterInstanceARN", (Object)this.identityCenterInstanceARN()).add("SubjectKey", (Object)this.subjectKeyAsString()).add("RolesKey", (Object)this.rolesKeyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnabledAPIAccess": {
                return Optional.ofNullable(clazz.cast(this.enabledAPIAccess()));
            }
            case "IdentityCenterInstanceARN": {
                return Optional.ofNullable(clazz.cast(this.identityCenterInstanceARN()));
            }
            case "SubjectKey": {
                return Optional.ofNullable(clazz.cast(this.subjectKeyAsString()));
            }
            case "RolesKey": {
                return Optional.ofNullable(clazz.cast(this.rolesKeyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnabledAPIAccess", ENABLED_API_ACCESS_FIELD);
        map.put("IdentityCenterInstanceARN", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityCenterOptionsInput, T> g) {
        return obj -> g.apply((IdentityCenterOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabledAPIAccess;
        private String identityCenterInstanceARN;
        private String subjectKey;
        private String rolesKey;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityCenterOptionsInput model) {
            this.enabledAPIAccess(model.enabledAPIAccess);
            this.identityCenterInstanceARN(model.identityCenterInstanceARN);
            this.subjectKey(model.subjectKey);
            this.rolesKey(model.rolesKey);
        }

        public final Boolean getEnabledAPIAccess() {
            return this.enabledAPIAccess;
        }

        public final void setEnabledAPIAccess(Boolean enabledAPIAccess) {
            this.enabledAPIAccess = enabledAPIAccess;
        }

        @Override
        public final Builder enabledAPIAccess(Boolean enabledAPIAccess) {
            this.enabledAPIAccess = enabledAPIAccess;
            return this;
        }

        public final String getIdentityCenterInstanceARN() {
            return this.identityCenterInstanceARN;
        }

        public final void setIdentityCenterInstanceARN(String identityCenterInstanceARN) {
            this.identityCenterInstanceARN = identityCenterInstanceARN;
        }

        @Override
        public final Builder identityCenterInstanceARN(String identityCenterInstanceARN) {
            this.identityCenterInstanceARN = identityCenterInstanceARN;
            return this;
        }

        public final String getSubjectKey() {
            return this.subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        @Override
        public final Builder subjectKey(SubjectKeyIdCOption subjectKey) {
            this.subjectKey(subjectKey == null ? null : subjectKey.toString());
            return this;
        }

        public final String getRolesKey() {
            return this.rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        @Override
        public final Builder rolesKey(RolesKeyIdCOption rolesKey) {
            this.rolesKey(rolesKey == null ? null : rolesKey.toString());
            return this;
        }

        public IdentityCenterOptionsInput build() {
            return new IdentityCenterOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityCenterOptionsInput> {
        public Builder enabledAPIAccess(Boolean var1);

        public Builder identityCenterInstanceARN(String var1);

        public Builder subjectKey(String var1);

        public Builder subjectKey(SubjectKeyIdCOption var1);

        public Builder rolesKey(String var1);

        public Builder rolesKey(RolesKeyIdCOption var1);
    }
}

