/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeOptionsNodeType {
    COORDINATOR("coordinator"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeOptionsNodeType> VALUE_MAP;
    private final String value;

    private NodeOptionsNodeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeOptionsNodeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeOptionsNodeType> knownValues() {
        EnumSet<NodeOptionsNodeType> knownValues = EnumSet.allOf(NodeOptionsNodeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeOptionsNodeType.class, NodeOptionsNodeType::toString);
    }
}

