/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse;

public class ListDomainsForPackageIterable
implements SdkIterable<ListDomainsForPackageResponse> {
    private final OpenSearchClient client;
    private final ListDomainsForPackageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainsForPackageIterable(OpenSearchClient client, ListDomainsForPackageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainsForPackageResponseFetcher();
    }

    public Iterator<ListDomainsForPackageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDomainsForPackageResponseFetcher
    implements SyncPageFetcher<ListDomainsForPackageResponse> {
        private ListDomainsForPackageResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsForPackageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainsForPackageResponse nextPage(ListDomainsForPackageResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsForPackageIterable.this.client.listDomainsForPackage(ListDomainsForPackageIterable.this.firstRequest);
            }
            return ListDomainsForPackageIterable.this.client.listDomainsForPackage((ListDomainsForPackageRequest)((Object)ListDomainsForPackageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

