/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.RolesKeyIdCOption;
import software.amazon.awssdk.services.opensearch.model.SubjectKeyIdCOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityCenterOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityCenterOptions> {
    private static final SdkField<Boolean> ENABLED_API_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnabledAPIAccess").getter(IdentityCenterOptions.getter(IdentityCenterOptions::enabledAPIAccess)).setter(IdentityCenterOptions.setter(Builder::enabledAPIAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledAPIAccess").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityCenterInstanceARN").getter(IdentityCenterOptions.getter(IdentityCenterOptions::identityCenterInstanceARN)).setter(IdentityCenterOptions.setter(Builder::identityCenterInstanceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterInstanceARN").build()}).build();
    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectKey").getter(IdentityCenterOptions.getter(IdentityCenterOptions::subjectKeyAsString)).setter(IdentityCenterOptions.setter(Builder::subjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()}).build();
    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RolesKey").getter(IdentityCenterOptions.getter(IdentityCenterOptions::rolesKeyAsString)).setter(IdentityCenterOptions.setter(Builder::rolesKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityCenterApplicationARN").getter(IdentityCenterOptions.getter(IdentityCenterOptions::identityCenterApplicationARN)).setter(IdentityCenterOptions.setter(Builder::identityCenterApplicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterApplicationARN").build()}).build();
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(IdentityCenterOptions.getter(IdentityCenterOptions::identityStoreId)).setter(IdentityCenterOptions.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_API_ACCESS_FIELD, IDENTITY_CENTER_INSTANCE_ARN_FIELD, SUBJECT_KEY_FIELD, ROLES_KEY_FIELD, IDENTITY_CENTER_APPLICATION_ARN_FIELD, IDENTITY_STORE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdentityCenterOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabledAPIAccess;
    private final String identityCenterInstanceARN;
    private final String subjectKey;
    private final String rolesKey;
    private final String identityCenterApplicationARN;
    private final String identityStoreId;

    private IdentityCenterOptions(BuilderImpl builder) {
        this.enabledAPIAccess = builder.enabledAPIAccess;
        this.identityCenterInstanceARN = builder.identityCenterInstanceARN;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
        this.identityCenterApplicationARN = builder.identityCenterApplicationARN;
        this.identityStoreId = builder.identityStoreId;
    }

    public final Boolean enabledAPIAccess() {
        return this.enabledAPIAccess;
    }

    public final String identityCenterInstanceARN() {
        return this.identityCenterInstanceARN;
    }

    public final SubjectKeyIdCOption subjectKey() {
        return SubjectKeyIdCOption.fromValue(this.subjectKey);
    }

    public final String subjectKeyAsString() {
        return this.subjectKey;
    }

    public final RolesKeyIdCOption rolesKey() {
        return RolesKeyIdCOption.fromValue(this.rolesKey);
    }

    public final String rolesKeyAsString() {
        return this.rolesKey;
    }

    public final String identityCenterApplicationARN() {
        return this.identityCenterApplicationARN;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledAPIAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterInstanceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolesKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterApplicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityCenterOptions)) {
            return false;
        }
        IdentityCenterOptions other = (IdentityCenterOptions)obj;
        return Objects.equals(this.enabledAPIAccess(), other.enabledAPIAccess()) && Objects.equals(this.identityCenterInstanceARN(), other.identityCenterInstanceARN()) && Objects.equals(this.subjectKeyAsString(), other.subjectKeyAsString()) && Objects.equals(this.rolesKeyAsString(), other.rolesKeyAsString()) && Objects.equals(this.identityCenterApplicationARN(), other.identityCenterApplicationARN()) && Objects.equals(this.identityStoreId(), other.identityStoreId());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityCenterOptions").add("EnabledAPIAccess", (Object)this.enabledAPIAccess()).add("IdentityCenterInstanceARN", (Object)this.identityCenterInstanceARN()).add("SubjectKey", (Object)this.subjectKeyAsString()).add("RolesKey", (Object)this.rolesKeyAsString()).add("IdentityCenterApplicationARN", (Object)this.identityCenterApplicationARN()).add("IdentityStoreId", (Object)this.identityStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnabledAPIAccess": {
                return Optional.ofNullable(clazz.cast(this.enabledAPIAccess()));
            }
            case "IdentityCenterInstanceARN": {
                return Optional.ofNullable(clazz.cast(this.identityCenterInstanceARN()));
            }
            case "SubjectKey": {
                return Optional.ofNullable(clazz.cast(this.subjectKeyAsString()));
            }
            case "RolesKey": {
                return Optional.ofNullable(clazz.cast(this.rolesKeyAsString()));
            }
            case "IdentityCenterApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.identityCenterApplicationARN()));
            }
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnabledAPIAccess", ENABLED_API_ACCESS_FIELD);
        map.put("IdentityCenterInstanceARN", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        map.put("IdentityCenterApplicationARN", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityCenterOptions, T> g) {
        return obj -> g.apply((IdentityCenterOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabledAPIAccess;
        private String identityCenterInstanceARN;
        private String subjectKey;
        private String rolesKey;
        private String identityCenterApplicationARN;
        private String identityStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityCenterOptions model) {
            this.enabledAPIAccess(model.enabledAPIAccess);
            this.identityCenterInstanceARN(model.identityCenterInstanceARN);
            this.subjectKey(model.subjectKey);
            this.rolesKey(model.rolesKey);
            this.identityCenterApplicationARN(model.identityCenterApplicationARN);
            this.identityStoreId(model.identityStoreId);
        }

        public final Boolean getEnabledAPIAccess() {
            return this.enabledAPIAccess;
        }

        public final void setEnabledAPIAccess(Boolean enabledAPIAccess) {
            this.enabledAPIAccess = enabledAPIAccess;
        }

        @Override
        public final Builder enabledAPIAccess(Boolean enabledAPIAccess) {
            this.enabledAPIAccess = enabledAPIAccess;
            return this;
        }

        public final String getIdentityCenterInstanceARN() {
            return this.identityCenterInstanceARN;
        }

        public final void setIdentityCenterInstanceARN(String identityCenterInstanceARN) {
            this.identityCenterInstanceARN = identityCenterInstanceARN;
        }

        @Override
        public final Builder identityCenterInstanceARN(String identityCenterInstanceARN) {
            this.identityCenterInstanceARN = identityCenterInstanceARN;
            return this;
        }

        public final String getSubjectKey() {
            return this.subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        @Override
        public final Builder subjectKey(SubjectKeyIdCOption subjectKey) {
            this.subjectKey(subjectKey == null ? null : subjectKey.toString());
            return this;
        }

        public final String getRolesKey() {
            return this.rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        @Override
        public final Builder rolesKey(RolesKeyIdCOption rolesKey) {
            this.rolesKey(rolesKey == null ? null : rolesKey.toString());
            return this;
        }

        public final String getIdentityCenterApplicationARN() {
            return this.identityCenterApplicationARN;
        }

        public final void setIdentityCenterApplicationARN(String identityCenterApplicationARN) {
            this.identityCenterApplicationARN = identityCenterApplicationARN;
        }

        @Override
        public final Builder identityCenterApplicationARN(String identityCenterApplicationARN) {
            this.identityCenterApplicationARN = identityCenterApplicationARN;
            return this;
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public IdentityCenterOptions build() {
            return new IdentityCenterOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityCenterOptions> {
        public Builder enabledAPIAccess(Boolean var1);

        public Builder identityCenterInstanceARN(String var1);

        public Builder subjectKey(String var1);

        public Builder subjectKey(SubjectKeyIdCOption var1);

        public Builder rolesKey(String var1);

        public Builder rolesKey(RolesKeyIdCOption var1);

        public Builder identityCenterApplicationARN(String var1);

        public Builder identityStoreId(String var1);
    }
}

