/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.ActivityListCopier;
import software.amazon.awssdk.services.sfn.model.ActivityListItem;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActivitiesResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ListActivitiesResponse> {
    private static final SdkField<List<ActivityListItem>> ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activities").getter(ListActivitiesResponse.getter(ListActivitiesResponse::activities)).setter(ListActivitiesResponse.setter(Builder::activities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActivityListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActivitiesResponse.getter(ListActivitiesResponse::nextToken)).setter(ListActivitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListActivitiesResponse.memberNameToFieldInitializer();
    private final List<ActivityListItem> activities;
    private final String nextToken;

    private ListActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.activities = builder.activities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActivities() {
        return this.activities != null && !(this.activities instanceof SdkAutoConstructList);
    }

    public final List<ActivityListItem> activities() {
        return this.activities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActivities() ? this.activities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivitiesResponse)) {
            return false;
        }
        ListActivitiesResponse other = (ListActivitiesResponse)((Object)obj);
        return this.hasActivities() == other.hasActivities() && Objects.equals(this.activities(), other.activities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActivitiesResponse").add("Activities", this.hasActivities() ? this.activities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activities": {
                return Optional.ofNullable(clazz.cast(this.activities()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activities", ACTIVITIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActivitiesResponse, T> g) {
        return obj -> g.apply((ListActivitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private List<ActivityListItem> activities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivitiesResponse model) {
            super(model);
            this.activities(model.activities);
            this.nextToken(model.nextToken);
        }

        public final List<ActivityListItem.Builder> getActivities() {
            List<ActivityListItem.Builder> result = ActivityListCopier.copyToBuilder(this.activities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActivities(Collection<ActivityListItem.BuilderImpl> activities) {
            this.activities = ActivityListCopier.copyFromBuilder(activities);
        }

        @Override
        public final Builder activities(Collection<ActivityListItem> activities) {
            this.activities = ActivityListCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(ActivityListItem ... activities) {
            this.activities(Arrays.asList(activities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Consumer<ActivityListItem.Builder> ... activities) {
            this.activities(Stream.of(activities).map(c -> (ActivityListItem)((ActivityListItem.Builder)ActivityListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListActivitiesResponse build() {
            return new ListActivitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActivitiesResponse> {
        public Builder activities(Collection<ActivityListItem> var1);

        public Builder activities(ActivityListItem ... var1);

        public Builder activities(Consumer<ActivityListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

