/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.batchmanager.IdentifiableMessage;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchConfiguration;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchManager;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.SqsException;
import software.amazon.awssdk.utils.Either;

@SdkInternalApi
public class ChangeMessageVisibilityBatchManager
extends RequestBatchManager<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse, ChangeMessageVisibilityBatchResponse> {
    private final SqsAsyncClient sqsAsyncClient;

    protected ChangeMessageVisibilityBatchManager(RequestBatchConfiguration overrideConfiguration, ScheduledExecutorService scheduledExecutor, SqsAsyncClient sqsAsyncClient) {
        super(overrideConfiguration, scheduledExecutor);
        this.sqsAsyncClient = sqsAsyncClient;
    }

    private static ChangeMessageVisibilityBatchRequest createChangeMessageVisibilityBatchRequest(List<IdentifiableMessage<ChangeMessageVisibilityRequest>> identifiedRequests, String batchKey) {
        List entries = identifiedRequests.stream().map(identifiedRequest -> ChangeMessageVisibilityBatchManager.createChangeMessageVisibilityBatchRequestEntry(identifiedRequest.id(), (ChangeMessageVisibilityRequest)((Object)((Object)identifiedRequest.message())))).collect(Collectors.toList());
        Optional overrideConfiguration = identifiedRequests.get(0).message().overrideConfiguration();
        return overrideConfiguration.map(config -> (ChangeMessageVisibilityBatchRequest)((Object)((Object)ChangeMessageVisibilityBatchRequest.builder().queueUrl(batchKey).overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)config.toBuilder().applyMutation(USER_AGENT_APPLIER)).build()).entries(entries).build()))).orElseGet(() -> (ChangeMessageVisibilityBatchRequest)((Object)((Object)ChangeMessageVisibilityBatchRequest.builder().queueUrl(batchKey).overrideConfiguration(o -> ((AwsRequestOverrideConfiguration.Builder)o.applyMutation(USER_AGENT_APPLIER)).build()).entries(entries).build())));
    }

    private static ChangeMessageVisibilityBatchRequestEntry createChangeMessageVisibilityBatchRequestEntry(String id, ChangeMessageVisibilityRequest request) {
        return (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().id(id).receiptHandle(request.receiptHandle()).visibilityTimeout(request.visibilityTimeout()).build();
    }

    private static IdentifiableMessage<ChangeMessageVisibilityResponse> createChangeMessageVisibilityResponse(ChangeMessageVisibilityBatchResultEntry successfulEntry, ChangeMessageVisibilityBatchResponse batchResponse) {
        String key = successfulEntry.id();
        ChangeMessageVisibilityResponse.Builder builder = ChangeMessageVisibilityResponse.builder();
        if (batchResponse.responseMetadata() != null) {
            builder.responseMetadata(batchResponse.responseMetadata());
        }
        if (batchResponse.sdkHttpResponse() != null) {
            builder.sdkHttpResponse(batchResponse.sdkHttpResponse());
        }
        ChangeMessageVisibilityResponse response = (ChangeMessageVisibilityResponse)((Object)builder.build());
        return new IdentifiableMessage<ChangeMessageVisibilityResponse>(key, response);
    }

    private static IdentifiableMessage<Throwable> changeMessageVisibilityCreateThrowable(BatchResultErrorEntry failedEntry) {
        String key = failedEntry.id();
        AwsErrorDetails errorDetailsBuilder = AwsErrorDetails.builder().errorCode(failedEntry.code()).errorMessage(failedEntry.message()).build();
        AwsServiceException response = SqsException.builder().awsErrorDetails(errorDetailsBuilder).build();
        return new IdentifiableMessage<AwsServiceException>(key, response);
    }

    @Override
    protected CompletableFuture<ChangeMessageVisibilityBatchResponse> batchAndSend(List<IdentifiableMessage<ChangeMessageVisibilityRequest>> identifiedRequests, String batchKey) {
        ChangeMessageVisibilityBatchRequest batchRequest = ChangeMessageVisibilityBatchManager.createChangeMessageVisibilityBatchRequest(identifiedRequests, batchKey);
        return this.sqsAsyncClient.changeMessageVisibilityBatch(batchRequest);
    }

    @Override
    protected String getBatchKey(ChangeMessageVisibilityRequest request) {
        return request.overrideConfiguration().map(overrideConfig -> request.queueUrl() + overrideConfig.hashCode()).orElseGet(request::queueUrl);
    }

    @Override
    protected List<Either<IdentifiableMessage<ChangeMessageVisibilityResponse>, IdentifiableMessage<Throwable>>> mapBatchResponse(ChangeMessageVisibilityBatchResponse batchResponse) {
        ArrayList<Either<IdentifiableMessage<ChangeMessageVisibilityResponse>, IdentifiableMessage<Throwable>>> mappedResponses = new ArrayList<Either<IdentifiableMessage<ChangeMessageVisibilityResponse>, IdentifiableMessage<Throwable>>>();
        batchResponse.successful().forEach(batchResponseEntry -> {
            IdentifiableMessage<ChangeMessageVisibilityResponse> response = ChangeMessageVisibilityBatchManager.createChangeMessageVisibilityResponse(batchResponseEntry, batchResponse);
            mappedResponses.add(Either.left(response));
        });
        batchResponse.failed().forEach(batchResponseEntry -> {
            IdentifiableMessage<Throwable> response = ChangeMessageVisibilityBatchManager.changeMessageVisibilityCreateThrowable(batchResponseEntry);
            mappedResponses.add(Either.right(response));
        });
        return mappedResponses;
    }
}

