/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsServiceClientConfiguration;
import software.amazon.awssdk.services.sqs.batchmanager.SqsAsyncBatchManager;
import software.amazon.awssdk.services.sqs.endpoints.SqsClientContextParams;
import software.amazon.awssdk.services.sqs.internal.SqsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.AddPermissionResponse;
import software.amazon.awssdk.services.sqs.model.BatchEntryIdsNotDistinctException;
import software.amazon.awssdk.services.sqs.model.BatchRequestTooLongException;
import software.amazon.awssdk.services.sqs.model.CancelMessageMoveTaskRequest;
import software.amazon.awssdk.services.sqs.model.CancelMessageMoveTaskResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.EmptyBatchRequestException;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.InvalidAddressException;
import software.amazon.awssdk.services.sqs.model.InvalidAttributeNameException;
import software.amazon.awssdk.services.sqs.model.InvalidAttributeValueException;
import software.amazon.awssdk.services.sqs.model.InvalidBatchEntryIdException;
import software.amazon.awssdk.services.sqs.model.InvalidIdFormatException;
import software.amazon.awssdk.services.sqs.model.InvalidMessageContentsException;
import software.amazon.awssdk.services.sqs.model.InvalidSecurityException;
import software.amazon.awssdk.services.sqs.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.sqs.model.KmsDisabledException;
import software.amazon.awssdk.services.sqs.model.KmsInvalidKeyUsageException;
import software.amazon.awssdk.services.sqs.model.KmsInvalidStateException;
import software.amazon.awssdk.services.sqs.model.KmsNotFoundException;
import software.amazon.awssdk.services.sqs.model.KmsOptInRequiredException;
import software.amazon.awssdk.services.sqs.model.KmsThrottledException;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListMessageMoveTasksRequest;
import software.amazon.awssdk.services.sqs.model.ListMessageMoveTasksResponse;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.MessageNotInflightException;
import software.amazon.awssdk.services.sqs.model.OverLimitException;
import software.amazon.awssdk.services.sqs.model.PurgeQueueInProgressException;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.QueueDeletedRecentlyException;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.amazon.awssdk.services.sqs.model.QueueNameExistsException;
import software.amazon.awssdk.services.sqs.model.ReceiptHandleIsInvalidException;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sqs.model.RequestThrottledException;
import software.amazon.awssdk.services.sqs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.SqsException;
import software.amazon.awssdk.services.sqs.model.StartMessageMoveTaskRequest;
import software.amazon.awssdk.services.sqs.model.StartMessageMoveTaskResponse;
import software.amazon.awssdk.services.sqs.model.TagQueueRequest;
import software.amazon.awssdk.services.sqs.model.TagQueueResponse;
import software.amazon.awssdk.services.sqs.model.TooManyEntriesInBatchRequestException;
import software.amazon.awssdk.services.sqs.model.UnsupportedOperationException;
import software.amazon.awssdk.services.sqs.model.UntagQueueRequest;
import software.amazon.awssdk.services.sqs.model.UntagQueueResponse;
import software.amazon.awssdk.services.sqs.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.CancelMessageMoveTaskRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueUrlRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListDeadLetterSourceQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListMessageMoveTasksRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueueTagsRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiveMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.StartMessageMoveTaskRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.TagQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.UntagQueueRequestMarshaller;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
final class DefaultSqsAsyncClient
implements SqsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSqsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultSqsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SQS#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, addPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddPermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddPermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddPermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addPermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$addPermission$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$addPermission$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelMessageMoveTaskResponse> cancelMessageMoveTask(CancelMessageMoveTaskRequest cancelMessageMoveTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelMessageMoveTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, cancelMessageMoveTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelMessageMoveTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelMessageMoveTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelMessageMoveTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelMessageMoveTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelMessageMoveTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$cancelMessageMoveTask$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$cancelMessageMoveTask$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)changeMessageVisibilityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, changeMessageVisibilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangeMessageVisibility");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ChangeMessageVisibilityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeMessageVisibility").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ChangeMessageVisibilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)changeMessageVisibilityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$changeMessageVisibility$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$changeMessageVisibility$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityBatchResponse> changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)changeMessageVisibilityBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, changeMessageVisibilityBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangeMessageVisibilityBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ChangeMessageVisibilityBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeMessageVisibilityBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ChangeMessageVisibilityBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)changeMessageVisibilityBatchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$changeMessageVisibilityBatch$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$changeMessageVisibilityBatch$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, createQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateQueueResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createQueueRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$createQueue$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$createQueue$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMessageResponse> deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMessageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMessageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$deleteMessage$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$deleteMessage$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMessageBatchResponse> deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMessageBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteMessageBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMessageBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMessageBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMessageBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteMessageBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMessageBatchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$deleteMessageBatch$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$deleteMessageBatch$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteQueueResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteQueueRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$deleteQueue$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$deleteQueue$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueueAttributesResponse> getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueueAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, getQueueAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueueAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueueAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueueAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetQueueAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getQueueAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$getQueueAttributes$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$getQueueAttributes$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueueUrlResponse> getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueueUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, getQueueUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueueUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueueUrlResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueueUrl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetQueueUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getQueueUrlRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$getQueueUrl$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$getQueueUrl$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDeadLetterSourceQueuesResponse> listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDeadLetterSourceQueuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, listDeadLetterSourceQueuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDeadLetterSourceQueues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeadLetterSourceQueuesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeadLetterSourceQueues").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDeadLetterSourceQueuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDeadLetterSourceQueuesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$listDeadLetterSourceQueues$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$listDeadLetterSourceQueues$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListMessageMoveTasksResponse> listMessageMoveTasks(ListMessageMoveTasksRequest listMessageMoveTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMessageMoveTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, listMessageMoveTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMessageMoveTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMessageMoveTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMessageMoveTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListMessageMoveTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMessageMoveTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$listMessageMoveTasks$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$listMessageMoveTasks$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListQueueTagsResponse> listQueueTags(ListQueueTagsRequest listQueueTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listQueueTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, listQueueTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQueueTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueueTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueueTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListQueueTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listQueueTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$listQueueTags$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$listQueueTags$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListQueuesResponse> listQueues(ListQueuesRequest listQueuesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listQueuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, listQueuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQueues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueuesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueues").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListQueuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listQueuesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$listQueues$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$listQueues$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PurgeQueueResponse> purgeQueue(PurgeQueueRequest purgeQueueRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purgeQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, purgeQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurgeQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurgeQueueResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurgeQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PurgeQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)purgeQueueRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$purgeQueue$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$purgeQueue$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)receiveMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, receiveMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReceiveMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReceiveMessageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReceiveMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReceiveMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)receiveMessageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$receiveMessage$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$receiveMessage$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, removePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemovePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemovePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removePermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$removePermission$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$removePermission$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendMessageResponse> sendMessage(SendMessageRequest sendMessageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, sendMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendMessageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendMessageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$sendMessage$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$sendMessage$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendMessageBatchResponse> sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendMessageBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, sendMessageBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendMessageBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendMessageBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendMessageBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendMessageBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendMessageBatchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$sendMessageBatch$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$sendMessageBatch$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetQueueAttributesResponse> setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setQueueAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, setQueueAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetQueueAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetQueueAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetQueueAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetQueueAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setQueueAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$setQueueAttributes$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$setQueueAttributes$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartMessageMoveTaskResponse> startMessageMoveTask(StartMessageMoveTaskRequest startMessageMoveTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMessageMoveTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, startMessageMoveTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMessageMoveTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMessageMoveTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMessageMoveTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartMessageMoveTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startMessageMoveTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$startMessageMoveTask$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$startMessageMoveTask$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagQueueResponse> tagQueue(TagQueueRequest tagQueueRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, tagQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagQueueResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagQueueRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$tagQueue$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$tagQueue$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagQueueResponse> untagQueue(UntagQueueRequest untagQueueRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSqsAsyncClient.resolveMetricPublishers(clientConfiguration, untagQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SQS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagQueue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagQueueResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "PurgeQueueInProgress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PurgeQueueInProgress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PurgeQueueInProgressException::builder).build());
                    }
                    case "KmsInvalidKeyUsage": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsage").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                    }
                    case "InvalidAttributeName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeNameException::builder).build());
                    }
                    case "RequestThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestThrottledException::builder).build());
                    }
                    case "BatchEntryIdsNotDistinct": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).build());
                    }
                    case "TooManyEntriesInBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "BatchRequestTooLong": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchRequestTooLongException::builder).build());
                    }
                    case "UnsupportedOperation": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "KmsInvalidState": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidState").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "InvalidIdFormat": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdFormat").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdFormatException::builder).build());
                    }
                    case "KmsNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                    }
                    case "KmsThrottled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottledException::builder).build());
                    }
                    case "KmsOptInRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsOptInRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsOptInRequiredException::builder).build());
                    }
                    case "KmsAccessDenied": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDenied").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "OverLimit": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OverLimit").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OverLimitException::builder).build());
                    }
                    case "QueueDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDoesNotExistException::builder).build());
                    }
                    case "KmsDisabled": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabled").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                    }
                    case "QueueNameExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueNameExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueNameExistsException::builder).build());
                    }
                    case "MessageNotInflight": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MessageNotInflight").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MessageNotInflightException::builder).build());
                    }
                    case "ReceiptHandleIsInvalid": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReceiptHandleIsInvalid").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReceiptHandleIsInvalidException::builder).build());
                    }
                    case "InvalidAttributeValue": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAttributeValue").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAttributeValueException::builder).build());
                    }
                    case "InvalidMessageContents": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMessageContents").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMessageContentsException::builder).build());
                    }
                    case "QueueDeletedRecently": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QueueDeletedRecently").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueueDeletedRecentlyException::builder).build());
                    }
                    case "EmptyBatchRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyBatchRequestException::builder).build());
                    }
                    case "InvalidSecurity": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSecurity").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSecurityException::builder).build());
                    }
                    case "InvalidAddress": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddress").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "InvalidBatchEntryId": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagQueueRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSqsAsyncClient.lambda$untagQueue$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSqsAsyncClient.lambda$untagQueue$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public SqsAsyncBatchManager batchManager() {
        return SqsAsyncBatchManager.builder().client(this).scheduledExecutor(this.executorService).build();
    }

    @Override
    public final SqsServiceClientConfiguration serviceClientConfiguration() {
        return new SqsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "sqs";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SqsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").hasAwsQueryCompatible(true);
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SqsServiceClientConfigurationBuilder serviceConfigBuilder = new SqsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        AttributeMap newContextParams = (AttributeMap)configuration.option((ClientOption)SdkClientOption.CLIENT_CONTEXT_PARAMS);
        AttributeMap originalContextParams = (AttributeMap)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_CONTEXT_PARAMS);
        newContextParams = newContextParams != null ? newContextParams : AttributeMap.empty();
        originalContextParams = originalContextParams != null ? originalContextParams : AttributeMap.empty();
        Validate.validState((boolean)Objects.equals(originalContextParams.get(SqsClientContextParams.CHECKSUM_VALIDATION_ENABLED), newContextParams.get(SqsClientContextParams.CHECKSUM_VALIDATION_ENABLED)), (String)"CHECKSUM_VALIDATION_ENABLED cannot be modified by request level plugins", (Object[])new Object[0]);
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagQueue$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagQueue$90(List metricPublishers, MetricCollector apiCallMetricCollector, UntagQueueResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagQueue$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagQueue$86(List metricPublishers, MetricCollector apiCallMetricCollector, TagQueueResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startMessageMoveTask$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMessageMoveTask$82(List metricPublishers, MetricCollector apiCallMetricCollector, StartMessageMoveTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setQueueAttributes$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setQueueAttributes$78(List metricPublishers, MetricCollector apiCallMetricCollector, SetQueueAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendMessageBatch$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendMessageBatch$74(List metricPublishers, MetricCollector apiCallMetricCollector, SendMessageBatchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendMessage$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendMessage$70(List metricPublishers, MetricCollector apiCallMetricCollector, SendMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removePermission$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removePermission$66(List metricPublishers, MetricCollector apiCallMetricCollector, RemovePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$receiveMessage$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$receiveMessage$62(List metricPublishers, MetricCollector apiCallMetricCollector, ReceiveMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$purgeQueue$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purgeQueue$58(List metricPublishers, MetricCollector apiCallMetricCollector, PurgeQueueResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listQueues$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQueues$54(List metricPublishers, MetricCollector apiCallMetricCollector, ListQueuesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listQueueTags$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQueueTags$50(List metricPublishers, MetricCollector apiCallMetricCollector, ListQueueTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMessageMoveTasks$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMessageMoveTasks$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListMessageMoveTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDeadLetterSourceQueues$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDeadLetterSourceQueues$42(List metricPublishers, MetricCollector apiCallMetricCollector, ListDeadLetterSourceQueuesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getQueueUrl$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueueUrl$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetQueueUrlResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getQueueAttributes$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueueAttributes$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetQueueAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteQueue$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteQueue$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteQueueResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMessageBatch$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMessageBatch$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMessageBatchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMessage$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMessage$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createQueue$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createQueue$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateQueueResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$changeMessageVisibilityBatch$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$changeMessageVisibilityBatch$14(List metricPublishers, MetricCollector apiCallMetricCollector, ChangeMessageVisibilityBatchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$changeMessageVisibility$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$changeMessageVisibility$10(List metricPublishers, MetricCollector apiCallMetricCollector, ChangeMessageVisibilityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelMessageMoveTask$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelMessageMoveTask$6(List metricPublishers, MetricCollector apiCallMetricCollector, CancelMessageMoveTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addPermission$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addPermission$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddPermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

