/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttachmentHashType {
    SHA256("Sha256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttachmentHashType> VALUE_MAP;
    private final String value;

    private AttachmentHashType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttachmentHashType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttachmentHashType> knownValues() {
        EnumSet<AttachmentHashType> knownValues = EnumSet.allOf(AttachmentHashType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttachmentHashType.class, AttachmentHashType::toString);
    }
}

